/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IdentifierValue {
    private static final Log log = LogFactory.getLog(IdentifierValue.class);
    private final Serializable value;
    public static final IdentifierValue ANY = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy ANY");
            return Boolean.TRUE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        public String toString() {
            return "SAVE_ANY";
        }
    };
    public static final IdentifierValue NONE = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy NONE");
            return Boolean.FALSE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return currentValue;
        }

        public String toString() {
            return "SAVE_NONE";
        }
    };
    public static final IdentifierValue NULL = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy NULL");
            return id == null ? Boolean.TRUE : Boolean.FALSE;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        public String toString() {
            return "SAVE_NULL";
        }
    };
    public static final IdentifierValue UNDEFINED = new IdentifierValue(){

        public final Boolean isUnsaved(Serializable id) {
            log.trace("id unsaved-value strategy UNDEFINED");
            return null;
        }

        public Serializable getDefaultValue(Serializable currentValue) {
            return null;
        }

        public String toString() {
            return "UNDEFINED";
        }
    };

    protected IdentifierValue() {
        this.value = null;
    }

    public IdentifierValue(Serializable value) {
        this.value = value;
    }

    public Boolean isUnsaved(Serializable id) {
        if (log.isTraceEnabled()) {
            log.trace("id unsaved-value: " + this.value);
        }
        return id == null || id.equals(this.value) ? Boolean.TRUE : Boolean.FALSE;
    }

    public Serializable getDefaultValue(Serializable currentValue) {
        return this.value;
    }

    public String toString() {
        return "identifier unsaved-value: " + this.value;
    }
}

