/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine;

import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.engine.CascadingAction;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public final class Nullability {
    private final SessionImplementor session;

    public Nullability(SessionImplementor session) {
        this.session = session;
    }

    public void checkNullability(Object[] values, EntityPersister persister, boolean isUpdate) throws PropertyValueException, HibernateException {
        boolean[] nullability = persister.getPropertyNullability();
        boolean[] checkability = isUpdate ? persister.getPropertyUpdateability() : persister.getPropertyInsertability();
        Type[] propertyTypes = persister.getPropertyTypes();
        for (int i2 = 0; i2 < values.length; ++i2) {
            String breakProperties;
            if (!checkability[i2] || values[i2] == LazyPropertyInitializer.UNFETCHED_PROPERTY) continue;
            Object value = values[i2];
            if (!nullability[i2] && value == null) {
                throw new PropertyValueException("not-null property references a null or transient value", persister.getEntityName(), persister.getPropertyNames()[i2]);
            }
            if (value == null || (breakProperties = this.checkSubElementsNullability(propertyTypes[i2], value)) == null) continue;
            throw new PropertyValueException("not-null property references a null or transient value", persister.getEntityName(), Nullability.buildPropertyPath(persister.getPropertyNames()[i2], breakProperties));
        }
    }

    private String checkSubElementsNullability(Type propertyType, Object value) throws HibernateException {
        CollectionType collectionType;
        Type collectionElementType;
        if (propertyType.isComponentType()) {
            return this.checkComponentNullability(value, (AbstractComponentType)propertyType);
        }
        if (propertyType.isCollectionType() && (collectionElementType = (collectionType = (CollectionType)propertyType).getElementType(this.session.getFactory())).isComponentType()) {
            AbstractComponentType componentType = (AbstractComponentType)collectionElementType;
            Iterator iter = CascadingAction.getLoadedElementsIterator(this.session, collectionType, value);
            while (iter.hasNext()) {
                Object compValue = iter.next();
                if (compValue == null) continue;
                return this.checkComponentNullability(compValue, componentType);
            }
        }
        return null;
    }

    private String checkComponentNullability(Object value, AbstractComponentType compType) throws HibernateException {
        boolean[] nullability = compType.getPropertyNullability();
        if (nullability != null) {
            Object[] values = compType.getPropertyValues(value, this.session.getEntityMode());
            Type[] propertyTypes = compType.getSubtypes();
            for (int i2 = 0; i2 < values.length; ++i2) {
                String breakProperties;
                Object subvalue = values[i2];
                if (!nullability[i2] && subvalue == null) {
                    return compType.getPropertyNames()[i2];
                }
                if (subvalue == null || (breakProperties = this.checkSubElementsNullability(propertyTypes[i2], subvalue)) == null) continue;
                return Nullability.buildPropertyPath(compType.getPropertyNames()[i2], breakProperties);
            }
        }
        return null;
    }

    private static String buildPropertyPath(String parent, String child) {
        return new StringBuffer(parent.length() + child.length() + 1).append(parent).append('.').append(child).toString();
    }
}

