/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.query;

import org.hibernate.QueryException;
import org.hibernate.util.StringHelper;

public class ParameterParser {
    private ParameterParser() {
    }

    public static void parse(String sqlString, Recognizer recognizer) throws QueryException {
        boolean hasMainOutputParameter = sqlString.indexOf("call") > 0 && sqlString.indexOf("?") < sqlString.indexOf("call") && sqlString.indexOf("=") < sqlString.indexOf("call");
        boolean foundMainOutputParam = false;
        int stringLength = sqlString.length();
        boolean inQuote = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            String param;
            int chopLocation;
            int right;
            char c2 = sqlString.charAt(indx);
            if (inQuote) {
                if ('\'' == c2) {
                    inQuote = false;
                }
                recognizer.other(c2);
                continue;
            }
            if ('\'' == c2) {
                inQuote = true;
                recognizer.other(c2);
                continue;
            }
            if (c2 == ':') {
                right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", indx + 1);
                chopLocation = right < 0 ? sqlString.length() : right;
                param = sqlString.substring(indx + 1, chopLocation);
                if (StringHelper.isEmpty(param)) {
                    throw new QueryException("Space is not allowed after parameter prefix ':' '" + sqlString + "'");
                }
                recognizer.namedParameter(param, indx);
                indx = chopLocation - 1;
                continue;
            }
            if (c2 == '?') {
                if (indx < stringLength - 1 && Character.isDigit(sqlString.charAt(indx + 1))) {
                    right = StringHelper.firstIndexOfChar(sqlString, " \n\r\f\t,()=<>&|+-=/*'^![]#~\\", indx + 1);
                    chopLocation = right < 0 ? sqlString.length() : right;
                    param = sqlString.substring(indx + 1, chopLocation);
                    try {
                        new Integer(param);
                    }
                    catch (NumberFormatException e2) {
                        throw new QueryException("JPA-style positional param was not an integral ordinal");
                    }
                    recognizer.jpaPositionalParameter(param, indx);
                    indx = chopLocation - 1;
                    continue;
                }
                if (hasMainOutputParameter && !foundMainOutputParam) {
                    foundMainOutputParam = true;
                    recognizer.outParameter(indx);
                    continue;
                }
                recognizer.ordinalParameter(indx);
                continue;
            }
            recognizer.other(c2);
        }
    }

    public static interface Recognizer {
        public void outParameter(int var1);

        public void ordinalParameter(int var1);

        public void namedParameter(String var1, int var2);

        public void jpaPositionalParameter(String var1, int var2);

        public void other(char var1);
    }
}

