/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.event.def;

import org.hibernate.HibernateException;
import org.hibernate.event.EventSource;
import org.hibernate.intercept.LazyPropertyInitializer;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.type.CollectionType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;

public abstract class AbstractVisitor {
    private final EventSource session;

    AbstractVisitor(EventSource session) {
        this.session = session;
    }

    void processValues(Object[] values, Type[] types) throws HibernateException {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!this.includeProperty(values, i2)) continue;
            this.processValue(i2, values, types);
        }
    }

    public void processEntityPropertyValues(Object[] values, Type[] types) throws HibernateException {
        for (int i2 = 0; i2 < types.length; ++i2) {
            if (!this.includeEntityProperty(values, i2)) continue;
            this.processValue(i2, values, types);
        }
    }

    void processValue(int i2, Object[] values, Type[] types) {
        this.processValue(values[i2], types[i2]);
    }

    boolean includeEntityProperty(Object[] values, int i2) {
        return this.includeProperty(values, i2);
    }

    boolean includeProperty(Object[] values, int i2) {
        return values[i2] != LazyPropertyInitializer.UNFETCHED_PROPERTY;
    }

    Object processComponent(Object component, AbstractComponentType componentType) throws HibernateException {
        if (component != null) {
            this.processValues(componentType.getPropertyValues(component, this.session), componentType.getSubtypes());
        }
        return null;
    }

    final Object processValue(Object value, Type type) throws HibernateException {
        if (type.isCollectionType()) {
            return this.processCollection(value, (CollectionType)type);
        }
        if (type.isEntityType()) {
            return this.processEntity(value, (EntityType)type);
        }
        if (type.isComponentType()) {
            return this.processComponent(value, (AbstractComponentType)type);
        }
        return null;
    }

    void process(Object object, EntityPersister persister) throws HibernateException {
        this.processEntityPropertyValues(persister.getPropertyValues(object, this.getSession().getEntityMode()), persister.getPropertyTypes());
    }

    Object processCollection(Object collection, CollectionType type) throws HibernateException {
        return null;
    }

    Object processEntity(Object value, EntityType entityType) throws HibernateException {
        return null;
    }

    final EventSource getSession() {
        return this.session;
    }
}

