/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.SemanticException;
import antlr.collections.AST;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.hibernate.QueryException;
import org.hibernate.hql.antlr.SqlTokenTypes;
import org.hibernate.hql.ast.tree.ConstructorNode;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.SelectExpression;
import org.hibernate.hql.ast.tree.SelectExpressionImpl;
import org.hibernate.hql.ast.tree.SelectExpressionList;
import org.hibernate.hql.ast.util.ASTAppender;
import org.hibernate.hql.ast.util.ASTIterator;
import org.hibernate.hql.ast.util.ASTPrinter;
import org.hibernate.type.Type;

public class SelectClause
extends SelectExpressionList {
    private boolean prepared = false;
    private boolean scalarSelect;
    private List fromElementsForLoad = new ArrayList();
    private Type[] queryReturnTypes;
    private String[][] columnNames;
    private ConstructorNode constructorNode;
    private List collectionFromElements;
    private String[] aliases;
    public static boolean VERSION2_SQL = false;

    public boolean isScalarSelect() {
        return this.scalarSelect;
    }

    public boolean isDistinct() {
        return this.getFirstChild() != null && this.getFirstChild().getType() == 16;
    }

    public List getFromElementsForLoad() {
        return this.fromElementsForLoad;
    }

    public Type[] getQueryReturnTypes() {
        return this.queryReturnTypes;
    }

    public String[] getQueryReturnAliases() {
        return this.aliases;
    }

    public String[][] getColumnNames() {
        return this.columnNames;
    }

    public Constructor getConstructor() {
        return this.constructorNode == null ? null : this.constructorNode.getConstructor();
    }

    public boolean isMap() {
        return this.constructorNode == null ? false : this.constructorNode.isMap();
    }

    public boolean isList() {
        return this.constructorNode == null ? false : this.constructorNode.isList();
    }

    public void initializeExplicitSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>();
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        for (int i2 = 0; i2 < selectExpressions.length; ++i2) {
            SelectExpression expr = selectExpressions[i2];
            if (expr.isConstructor()) {
                this.constructorNode = (ConstructorNode)expr;
                List constructorArgumentTypeList = this.constructorNode.getConstructorArgumentTypeList();
                queryReturnTypeList.addAll(constructorArgumentTypeList);
                this.scalarSelect = true;
                continue;
            }
            Type type = expr.getDataType();
            if (type == null) {
                throw new IllegalStateException("No data type for node: " + expr.getClass().getName() + " " + new ASTPrinter(SqlTokenTypes.class).showAsString((AST)((Object)expr), ""));
            }
            if (expr.isScalar()) {
                this.scalarSelect = true;
            }
            if (this.isReturnableEntity(expr)) {
                this.fromElementsForLoad.add(expr.getFromElement());
            }
            queryReturnTypeList.add(type);
        }
        this.initAliases(selectExpressions);
        if (!this.getWalker().isShallowQuery()) {
            List fromElements = fromClause.getProjectionList();
            ASTAppender appender = new ASTAppender(this.getASTFactory(), this);
            int size = fromElements.size();
            Iterator iterator = fromElements.iterator();
            int k2 = 0;
            while (iterator.hasNext()) {
                FromElement fromElement = (FromElement)iterator.next();
                if (fromElement.isFetch()) {
                    boolean collectionOfElements;
                    FromElement origin = null;
                    if (fromElement.getRealOrigin() == null) {
                        if (fromElement.getOrigin() == null) {
                            throw new QueryException("Unable to determine origin of join fetch [" + fromElement.getDisplayText() + "]");
                        }
                        origin = fromElement.getOrigin();
                    } else {
                        origin = fromElement.getRealOrigin();
                    }
                    if (!this.fromElementsForLoad.contains(origin)) {
                        throw new QueryException("query specified join fetching, but the owner of the fetched association was not present in the select list [" + fromElement.getDisplayText() + "]");
                    }
                    Type type = fromElement.getSelectType();
                    this.addCollectionFromElement(fromElement);
                    if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                        fromElement.setIncludeSubclasses(true);
                        this.fromElementsForLoad.add(fromElement);
                        String text = fromElement.renderIdentifierSelect(size, k2);
                        SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(138, text, false);
                        if (generatedExpr != null) {
                            generatedExpr.setFromElement(fromElement);
                        }
                    }
                }
                ++k2;
            }
            this.renderNonScalarSelects(this.collectSelectExpressions(), fromClause);
        }
        if (this.scalarSelect || this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void finishInitialization(ArrayList queryReturnTypeList) {
        this.queryReturnTypes = queryReturnTypeList.toArray(new Type[queryReturnTypeList.size()]);
        this.initializeColumnNames();
        this.prepared = true;
    }

    private void initializeColumnNames() {
        this.columnNames = this.getSessionFactoryHelper().generateColumnNames(this.queryReturnTypes);
    }

    public void initializeDerivedSelectClause(FromClause fromClause) throws SemanticException {
        if (this.prepared) {
            throw new IllegalStateException("SelectClause was already prepared!");
        }
        List fromElements = fromClause.getProjectionList();
        ASTAppender appender = new ASTAppender(this.getASTFactory(), this);
        int size = fromElements.size();
        ArrayList<Type> sqlResultTypeList = new ArrayList<Type>(size);
        ArrayList<Type> queryReturnTypeList = new ArrayList<Type>(size);
        Iterator iterator = fromElements.iterator();
        int k2 = 0;
        while (iterator.hasNext()) {
            boolean collectionOfElements;
            FromElement fromElement = (FromElement)iterator.next();
            Type type = fromElement.getSelectType();
            this.addCollectionFromElement(fromElement);
            if (type != null && !(collectionOfElements = fromElement.isCollectionOfValuesOrComponents())) {
                if (!fromElement.isFetch()) {
                    queryReturnTypeList.add(type);
                }
                this.fromElementsForLoad.add(fromElement);
                sqlResultTypeList.add(type);
                String text = fromElement.renderIdentifierSelect(size, k2);
                SelectExpressionImpl generatedExpr = (SelectExpressionImpl)appender.append(138, text, false);
                if (generatedExpr != null) {
                    generatedExpr.setFromElement(fromElement);
                }
            }
            ++k2;
        }
        SelectExpression[] selectExpressions = this.collectSelectExpressions();
        if (this.getWalker().isShallowQuery()) {
            this.renderScalarSelects(selectExpressions, fromClause);
        } else {
            this.renderNonScalarSelects(selectExpressions, fromClause);
        }
        this.finishInitialization(queryReturnTypeList);
    }

    private void addCollectionFromElement(FromElement fromElement) {
        if (fromElement.isFetch() && (fromElement.isCollectionJoin() || fromElement.getQueryableCollection() != null)) {
            String suffix;
            if (this.collectionFromElements == null) {
                this.collectionFromElements = new ArrayList();
                suffix = VERSION2_SQL ? "__" : "0__";
            } else {
                suffix = Integer.toString(this.collectionFromElements.size()) + "__";
            }
            this.collectionFromElements.add(fromElement);
            fromElement.setCollectionSuffix(suffix);
        }
    }

    protected AST getFirstSelectExpression() {
        AST n2;
        for (n2 = this.getFirstChild(); n2 != null && (n2.getType() == 16 || n2.getType() == 4); n2 = n2.getNextSibling()) {
        }
        return n2;
    }

    private boolean isReturnableEntity(SelectExpression selectExpression) throws SemanticException {
        boolean isFetchOrValueCollection;
        FromElement fromElement = selectExpression.getFromElement();
        boolean bl = isFetchOrValueCollection = fromElement != null && (fromElement.isFetch() || fromElement.isCollectionOfValuesOrComponents());
        if (isFetchOrValueCollection) {
            return false;
        }
        return selectExpression.isReturnableEntity();
    }

    private void renderScalarSelects(SelectExpression[] se, FromClause currentFromClause) throws SemanticException {
        if (!currentFromClause.isSubQuery()) {
            for (int i2 = 0; i2 < se.length; ++i2) {
                SelectExpression expr = se[i2];
                expr.setScalarColumnText(i2);
            }
        }
    }

    private void initAliases(SelectExpression[] selectExpressions) {
        if (this.constructorNode == null) {
            this.aliases = new String[selectExpressions.length];
            for (int i2 = 0; i2 < selectExpressions.length; ++i2) {
                String alias = selectExpressions[i2].getAlias();
                this.aliases[i2] = alias == null ? Integer.toString(i2) : alias;
            }
        } else {
            this.aliases = this.constructorNode.getAliases();
        }
    }

    private void renderNonScalarSelects(SelectExpression[] selectExpressions, FromClause currentFromClause) throws SemanticException {
        FromElement fromElement;
        ASTAppender appender = new ASTAppender(this.getASTFactory(), this);
        int size = selectExpressions.length;
        int nonscalarSize = 0;
        for (int i2 = 0; i2 < size; ++i2) {
            if (selectExpressions[i2].isScalar()) continue;
            ++nonscalarSize;
        }
        int j2 = 0;
        for (int i3 = 0; i3 < size; ++i3) {
            SelectExpression expr;
            if (selectExpressions[i3].isScalar() || (fromElement = (expr = selectExpressions[i3]).getFromElement()) == null) continue;
            this.renderNonScalarIdentifiers(fromElement, nonscalarSize, j2, expr, appender);
            ++j2;
        }
        if (!currentFromClause.isSubQuery()) {
            int k2 = 0;
            for (int i4 = 0; i4 < size; ++i4) {
                if (selectExpressions[i4].isScalar() || (fromElement = selectExpressions[i4].getFromElement()) == null) continue;
                this.renderNonScalarProperties(appender, fromElement, nonscalarSize, k2);
                ++k2;
            }
        }
    }

    private void renderNonScalarIdentifiers(FromElement fromElement, int nonscalarSize, int j2, SelectExpression expr, ASTAppender appender) {
        String text = fromElement.renderIdentifierSelect(nonscalarSize, j2);
        if (!fromElement.getFromClause().isSubQuery()) {
            if (!this.scalarSelect && !this.getWalker().isShallowQuery()) {
                expr.setText(text);
            } else {
                appender.append(136, text, false);
            }
        }
    }

    private void renderNonScalarProperties(ASTAppender appender, FromElement fromElement, int nonscalarSize, int k2) {
        String text = fromElement.renderPropertySelect(nonscalarSize, k2);
        appender.append(136, text, false);
        if (fromElement.getQueryableCollection() != null && fromElement.isFetch()) {
            text = fromElement.renderCollectionSelectFragment(nonscalarSize, k2);
            appender.append(136, text, false);
        }
        ASTIterator iter = new ASTIterator(fromElement);
        while (iter.hasNext()) {
            FromElement child = (FromElement)iter.next();
            if (!child.isCollectionOfValuesOrComponents() || !child.isFetch()) continue;
            text = child.renderValueCollectionSelectFragment(nonscalarSize, nonscalarSize + k2);
            appender.append(136, text, false);
        }
    }

    public List getCollectionFromElements() {
        return this.collectionFromElements;
    }
}

