/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.impl;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.QueryParameters;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.exception.JDBCExceptionHelper;
import org.hibernate.hql.HolderInstantiator;
import org.hibernate.impl.AbstractScrollableResults;
import org.hibernate.loader.Loader;
import org.hibernate.type.Type;

public class FetchingScrollableResultsImpl
extends AbstractScrollableResults {
    private Object[] currentRow = null;
    private int currentPosition = 0;
    private Integer maxPosition = null;

    public FetchingScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, Loader loader, QueryParameters queryParameters, Type[] types, HolderInstantiator holderInstantiator) throws MappingException {
        super(rs, ps, sess, loader, queryParameters, types, holderInstantiator);
    }

    protected Object[] getCurrentRow() {
        return this.currentRow;
    }

    public boolean next() throws HibernateException {
        boolean afterLast;
        if (this.maxPosition != null && this.maxPosition <= this.currentPosition) {
            this.currentRow = null;
            this.currentPosition = this.maxPosition + 1;
            return false;
        }
        Object row = this.getLoader().loadSequentialRowsForward(this.getResultSet(), this.getSession(), this.getQueryParameters(), false);
        try {
            afterLast = this.getResultSet().isAfterLast();
        }
        catch (SQLException e2) {
            throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), e2, "exception calling isAfterLast()");
        }
        ++this.currentPosition;
        this.currentRow = new Object[]{row};
        if (afterLast && this.maxPosition == null) {
            this.maxPosition = new Integer(this.currentPosition);
        }
        this.afterScrollOperation();
        return true;
    }

    public boolean previous() throws HibernateException {
        if (this.currentPosition <= 1) {
            this.currentPosition = 0;
            this.currentRow = null;
            return false;
        }
        Object loadResult = this.getLoader().loadSequentialRowsReverse(this.getResultSet(), this.getSession(), this.getQueryParameters(), false, this.maxPosition != null && this.currentPosition > this.maxPosition);
        this.currentRow = new Object[]{loadResult};
        --this.currentPosition;
        this.afterScrollOperation();
        return true;
    }

    public boolean scroll(int positions) throws HibernateException {
        boolean more = false;
        if (positions > 0) {
            for (int i2 = 0; i2 < positions && (more = this.next()); ++i2) {
            }
        } else if (positions < 0) {
            for (int i3 = 0; i3 < 0 - positions && (more = this.previous()); ++i3) {
            }
        } else {
            throw new HibernateException("scroll(0) not valid");
        }
        this.afterScrollOperation();
        return more;
    }

    public boolean last() throws HibernateException {
        boolean more = false;
        if (this.maxPosition != null) {
            for (int i2 = this.currentPosition; i2 < this.maxPosition; ++i2) {
                more = this.next();
            }
        } else {
            try {
                if (this.getResultSet().isAfterLast()) {
                    return false;
                }
                while (!this.getResultSet().isAfterLast()) {
                    more = this.next();
                }
            }
            catch (SQLException e2) {
                throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), e2, "exception calling isAfterLast()");
            }
        }
        this.afterScrollOperation();
        return more;
    }

    public boolean first() throws HibernateException {
        this.beforeFirst();
        boolean more = this.next();
        this.afterScrollOperation();
        return more;
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.getResultSet().beforeFirst();
        }
        catch (SQLException e2) {
            throw JDBCExceptionHelper.convert(this.getSession().getFactory().getSQLExceptionConverter(), e2, "exception calling beforeFirst()");
        }
        this.currentRow = null;
        this.currentPosition = 0;
    }

    public void afterLast() throws HibernateException {
        this.last();
        this.next();
        this.afterScrollOperation();
    }

    public boolean isFirst() throws HibernateException {
        return this.currentPosition == 1;
    }

    public boolean isLast() throws HibernateException {
        if (this.maxPosition == null) {
            return false;
        }
        return this.currentPosition == this.maxPosition;
    }

    public int getRowNumber() throws HibernateException {
        return this.currentPosition;
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber == 1) {
            return this.first();
        }
        if (rowNumber == -1) {
            return this.last();
        }
        if (this.maxPosition != null && rowNumber == this.maxPosition) {
            return this.last();
        }
        return this.scroll(rowNumber - this.currentPosition);
    }
}

