/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.collection;

import java.io.Serializable;
import java.util.Map;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.loader.Loader;
import org.hibernate.loader.collection.BasicCollectionLoader;
import org.hibernate.loader.collection.CollectionInitializer;
import org.hibernate.loader.collection.OneToManyLoader;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.util.ArrayHelper;

public class BatchingCollectionInitializer
implements CollectionInitializer {
    private final Loader[] loaders;
    private final int[] batchSizes;
    private final CollectionPersister collectionPersister;

    public BatchingCollectionInitializer(CollectionPersister collPersister, int[] batchSizes, Loader[] loaders) {
        this.loaders = loaders;
        this.batchSizes = batchSizes;
        this.collectionPersister = collPersister;
    }

    public void initialize(Serializable id, SessionImplementor session) throws HibernateException {
        Serializable[] batch = session.getPersistenceContext().getBatchFetchQueue().getCollectionBatch(this.collectionPersister, id, this.batchSizes[0], session.getEntityMode());
        for (int i2 = 0; i2 < this.batchSizes.length - 1; ++i2) {
            int smallBatchSize = this.batchSizes[i2];
            if (batch[smallBatchSize - 1] == null) continue;
            Serializable[] smallBatch = new Serializable[smallBatchSize];
            System.arraycopy(batch, 0, smallBatch, 0, smallBatchSize);
            this.loaders[i2].loadCollectionBatch(session, smallBatch, this.collectionPersister.getKeyType());
            return;
        }
        this.loaders[this.batchSizes.length - 1].loadCollection(session, id, this.collectionPersister.getKeyType());
    }

    public static CollectionInitializer createBatchingOneToManyInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (maxBatchSize > 1) {
            int[] batchSizesToCreate = ArrayHelper.getBatchSizes(maxBatchSize);
            Loader[] loadersToCreate = new Loader[batchSizesToCreate.length];
            for (int i2 = 0; i2 < batchSizesToCreate.length; ++i2) {
                loadersToCreate[i2] = new OneToManyLoader(persister, batchSizesToCreate[i2], factory, enabledFilters);
            }
            return new BatchingCollectionInitializer(persister, batchSizesToCreate, loadersToCreate);
        }
        return new OneToManyLoader(persister, factory, enabledFilters);
    }

    public static CollectionInitializer createBatchingCollectionInitializer(QueryableCollection persister, int maxBatchSize, SessionFactoryImplementor factory, Map enabledFilters) throws MappingException {
        if (maxBatchSize > 1) {
            int[] batchSizesToCreate = ArrayHelper.getBatchSizes(maxBatchSize);
            Loader[] loadersToCreate = new Loader[batchSizesToCreate.length];
            for (int i2 = 0; i2 < batchSizesToCreate.length; ++i2) {
                loadersToCreate[i2] = new BasicCollectionLoader(persister, batchSizesToCreate[i2], factory, enabledFilters);
            }
            return new BatchingCollectionInitializer(persister, batchSizesToCreate, loadersToCreate);
        }
        return new BasicCollectionLoader(persister, factory, enabledFilters);
    }
}

