/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.LockMode;
import org.hibernate.dialect.Dialect;

public class SimpleSelect {
    private String tableName;
    private String orderBy;
    private Dialect dialect;
    private LockMode lockMode = LockMode.READ;
    private String comment;
    private List columns = new ArrayList();
    private Map aliases = new HashMap();
    private List whereTokens = new ArrayList();

    public SimpleSelect(Dialect dialect) {
        this.dialect = dialect;
    }

    public SimpleSelect addColumns(String[] columnNames, String[] columnAliases) {
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            if (columnNames[i2] == null) continue;
            this.addColumn(columnNames[i2], columnAliases[i2]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] columns, String[] aliases, boolean[] ignore) {
        for (int i2 = 0; i2 < ignore.length; ++i2) {
            if (ignore[i2] || columns[i2] == null) continue;
            this.addColumn(columns[i2], aliases[i2]);
        }
        return this;
    }

    public SimpleSelect addColumns(String[] columnNames) {
        for (int i2 = 0; i2 < columnNames.length; ++i2) {
            if (columnNames[i2] == null) continue;
            this.addColumn(columnNames[i2]);
        }
        return this;
    }

    public SimpleSelect addColumn(String columnName) {
        this.columns.add(columnName);
        return this;
    }

    public SimpleSelect addColumn(String columnName, String alias) {
        this.columns.add(columnName);
        this.aliases.put(columnName, alias);
        return this;
    }

    public SimpleSelect setTableName(String tableName) {
        this.tableName = tableName;
        return this;
    }

    public SimpleSelect setLockMode(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    public SimpleSelect addWhereToken(String token) {
        this.whereTokens.add(token);
        return this;
    }

    private void and() {
        if (this.whereTokens.size() > 0) {
            this.whereTokens.add("and");
        }
    }

    public SimpleSelect addCondition(String lhs, String op, String rhs) {
        this.and();
        this.whereTokens.add(lhs + ' ' + op + ' ' + rhs);
        return this;
    }

    public SimpleSelect addCondition(String lhs, String condition) {
        this.and();
        this.whereTokens.add(lhs + ' ' + condition);
        return this;
    }

    public SimpleSelect addCondition(String[] lhs, String op, String[] rhs) {
        for (int i2 = 0; i2 < lhs.length; ++i2) {
            this.addCondition(lhs[i2], op, rhs[i2]);
        }
        return this;
    }

    public SimpleSelect addCondition(String[] lhs, String condition) {
        for (int i2 = 0; i2 < lhs.length; ++i2) {
            if (lhs[i2] == null) continue;
            this.addCondition(lhs[i2], condition);
        }
        return this;
    }

    public String toStatementString() {
        StringBuffer buf = new StringBuffer(this.columns.size() * 10 + this.tableName.length() + this.whereTokens.size() * 10 + 10);
        if (this.comment != null) {
            buf.append("/* ").append(this.comment).append(" */ ");
        }
        buf.append("select ");
        HashSet<String> uniqueColumns = new HashSet<String>();
        Iterator iter = this.columns.iterator();
        boolean appendComma = false;
        while (iter.hasNext()) {
            String col = (String)iter.next();
            String alias = (String)this.aliases.get(col);
            if (!uniqueColumns.add(alias == null ? col : alias)) continue;
            if (appendComma) {
                buf.append(", ");
            }
            buf.append(col);
            if (alias != null && !alias.equals(col)) {
                buf.append(" as ").append(alias);
            }
            appendComma = true;
        }
        buf.append(" from ").append(this.dialect.appendLockHint(this.lockMode, this.tableName));
        if (this.whereTokens.size() > 0) {
            buf.append(" where ").append(this.toWhereClause());
        }
        if (this.orderBy != null) {
            buf.append(this.orderBy);
        }
        if (this.lockMode != null) {
            buf.append(this.dialect.getForUpdateString(this.lockMode));
        }
        return this.dialect.transformSelectString(buf.toString());
    }

    public String toWhereClause() {
        StringBuffer buf = new StringBuffer(this.whereTokens.size() * 5);
        Iterator iter = this.whereTokens.iterator();
        while (iter.hasNext()) {
            buf.append(iter.next());
            if (!iter.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    public SimpleSelect setOrderBy(String orderBy) {
        this.orderBy = orderBy;
        return this;
    }

    public SimpleSelect setComment(String comment) {
        this.comment = comment;
        return this;
    }
}

