/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.JDBCException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.cfg.Settings;
import org.hibernate.dialect.Dialect;
import org.hibernate.pretty.DDLFormatter;
import org.hibernate.tool.hbm2ddl.ConnectionHelper;
import org.hibernate.tool.hbm2ddl.ManagedProviderConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionHelper;
import org.hibernate.tool.hbm2ddl.SuppliedConnectionProviderConnectionHelper;
import org.hibernate.util.ConfigHelper;
import org.hibernate.util.JDBCExceptionReporter;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaExport {
    private static final Log log = LogFactory.getLog(SchemaExport.class);
    private ConnectionHelper connectionHelper;
    private String[] dropSQL;
    private String[] createSQL;
    private String outputFile = null;
    private String importFile = "/import.sql";
    private Dialect dialect;
    private String delimiter;
    private final List exceptions = new ArrayList();
    private boolean haltOnError = false;
    private boolean format = true;

    public SchemaExport(Configuration cfg) throws HibernateException {
        this(cfg, cfg.getProperties());
    }

    public SchemaExport(Configuration cfg, Settings settings) throws HibernateException {
        this.dialect = settings.getDialect();
        this.connectionHelper = new SuppliedConnectionProviderConnectionHelper(settings.getConnectionProvider());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.format = settings.isFormatSqlEnabled();
    }

    public SchemaExport(Configuration cfg, Properties properties) throws HibernateException {
        this.dialect = Dialect.getDialect(properties);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.dialect.getDefaultProperties());
        props.putAll((Map<?, ?>)properties);
        this.connectionHelper = new ManagedProviderConnectionHelper(props);
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
        this.format = PropertiesHelper.getBoolean("hibernate.format_sql", props);
    }

    public SchemaExport(Configuration cfg, Connection connection) {
        this.connectionHelper = new SuppliedConnectionHelper(connection);
        this.dialect = Dialect.getDialect(cfg.getProperties());
        this.dropSQL = cfg.generateDropSchemaScript(this.dialect);
        this.createSQL = cfg.generateSchemaCreationScript(this.dialect);
    }

    public SchemaExport setOutputFile(String filename) {
        this.outputFile = filename;
        return this;
    }

    public SchemaExport setImportFile(String filename) {
        this.importFile = filename;
        return this;
    }

    public SchemaExport setDelimiter(String delimiter) {
        this.delimiter = delimiter;
        return this;
    }

    public void create(boolean script, boolean export) {
        this.execute(script, export, false, false);
    }

    public void drop(boolean script, boolean export) {
        this.execute(script, export, true, false);
    }

    private String format(String sql) {
        return this.format ? new DDLFormatter(sql).format() : sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void execute(boolean script, boolean export, boolean justDrop, boolean justCreate) {
        block32: {
            log.info("Running hbm2ddl schema export");
            Connection connection = null;
            Writer outputFileWriter = null;
            InputStreamReader importFileReader = null;
            Statement statement = null;
            this.exceptions.clear();
            try {
                InputStream stream = ConfigHelper.getResourceAsStream(this.importFile);
                importFileReader = new InputStreamReader(stream);
            }
            catch (HibernateException e2) {
                log.debug("import file not found: " + this.importFile);
            }
            if (this.outputFile != null) {
                log.info("writing generated schema to file: " + this.outputFile);
                outputFileWriter = new FileWriter(this.outputFile);
            }
            if (export) {
                log.info("exporting generated schema to database");
                this.connectionHelper.prepare(true);
                connection = this.connectionHelper.getConnection();
                statement = connection.createStatement();
            }
            if (!justCreate) {
                this.drop(script, export, outputFileWriter, statement);
            }
            if (!justDrop) {
                this.create(script, export, outputFileWriter, statement);
                if (export && importFileReader != null) {
                    this.importScript(importFileReader, statement);
                }
            }
            log.info("schema export complete");
            Object var11_12 = null;
            try {
                if (statement != null) {
                    statement.close();
                }
                if (connection != null) {
                    this.connectionHelper.release();
                }
            }
            catch (Exception e3) {
                this.exceptions.add(e3);
                log.error("Could not close connection", e3);
            }
            try {
                if (outputFileWriter != null) {
                    outputFileWriter.close();
                }
                if (importFileReader != null) {
                    ((Reader)importFileReader).close();
                }
                break block32;
            }
            catch (IOException ioe) {
                this.exceptions.add(ioe);
                log.error("Error closing output file: " + this.outputFile, ioe);
            }
            break block32;
            {
                catch (Exception e4) {
                    this.exceptions.add(e4);
                    log.error("schema export unsuccessful", e4);
                    Object var11_13 = null;
                    try {
                        if (statement != null) {
                            statement.close();
                        }
                        if (connection != null) {
                            this.connectionHelper.release();
                        }
                    }
                    catch (Exception e3) {
                        this.exceptions.add(e3);
                        log.error("Could not close connection", e3);
                    }
                    try {
                        if (outputFileWriter != null) {
                            outputFileWriter.close();
                        }
                        if (importFileReader != null) {
                            ((Reader)importFileReader).close();
                        }
                        break block32;
                    }
                    catch (IOException ioe) {
                        this.exceptions.add(ioe);
                        log.error("Error closing output file: " + this.outputFile, ioe);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var11_14 = null;
                try {
                    if (statement != null) {
                        statement.close();
                    }
                    if (connection != null) {
                        this.connectionHelper.release();
                    }
                }
                catch (Exception e3) {
                    this.exceptions.add(e3);
                    log.error("Could not close connection", e3);
                }
                try {
                    if (outputFileWriter != null) {
                        outputFileWriter.close();
                    }
                    if (importFileReader != null) {
                        ((Reader)importFileReader).close();
                    }
                }
                catch (IOException ioe) {
                    this.exceptions.add(ioe);
                    log.error("Error closing output file: " + this.outputFile, ioe);
                }
                throw throwable;
            }
        }
    }

    private void importScript(Reader importFileReader, Statement statement) throws IOException {
        log.info("Executing import script: " + this.importFile);
        BufferedReader reader = new BufferedReader(importFileReader);
        String sql = reader.readLine();
        while (sql != null) {
            try {
                String trimmedSql = sql.trim();
                if (!(trimmedSql.length() == 0 || trimmedSql.startsWith("--") || trimmedSql.startsWith("//") || trimmedSql.startsWith("/*"))) {
                    if (trimmedSql.endsWith(";")) {
                        trimmedSql = trimmedSql.substring(0, trimmedSql.length() - 1);
                    }
                    log.debug(trimmedSql);
                    statement.execute(trimmedSql);
                }
            }
            catch (SQLException e2) {
                throw new JDBCException("Error during import script execution", e2);
            }
            sql = reader.readLine();
        }
    }

    private void create(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        for (int j2 = 0; j2 < this.createSQL.length; ++j2) {
            try {
                this.execute(script, export, fileOutput, statement, this.createSQL[j2]);
                continue;
            }
            catch (SQLException e2) {
                if (this.haltOnError) {
                    throw new JDBCException("Error during DDL export", e2);
                }
                this.exceptions.add(e2);
                log.error("Unsuccessful: " + this.createSQL[j2]);
                log.error(e2.getMessage());
            }
        }
    }

    private void drop(boolean script, boolean export, Writer fileOutput, Statement statement) throws IOException {
        for (int i2 = 0; i2 < this.dropSQL.length; ++i2) {
            try {
                this.execute(script, export, fileOutput, statement, this.dropSQL[i2]);
                continue;
            }
            catch (SQLException e2) {
                this.exceptions.add(e2);
                log.debug("Unsuccessful: " + this.dropSQL[i2]);
                log.debug(e2.getMessage());
            }
        }
    }

    private void execute(boolean script, boolean export, Writer fileOutput, Statement statement, String sql) throws IOException, SQLException {
        String formatted = this.format(sql);
        if (this.delimiter != null) {
            formatted = formatted + this.delimiter;
        }
        if (script) {
            System.out.println(formatted);
        }
        log.debug(formatted);
        if (this.outputFile != null) {
            fileOutput.write(formatted + "\n");
        }
        if (export) {
            statement.executeUpdate(sql);
            SQLWarning warnings = statement.getWarnings();
            if (warnings != null) {
                JDBCExceptionReporter.logAndClearWarnings(this.connectionHelper.getConnection());
            }
        }
    }

    public static void main(String[] args) {
        try {
            Configuration cfg = new Configuration();
            boolean script = true;
            boolean drop = false;
            boolean create = false;
            boolean halt = false;
            boolean export = true;
            String outFile = null;
            String importFile = "/import.sql";
            String propFile = null;
            boolean format = false;
            String delim = null;
            for (int i2 = 0; i2 < args.length; ++i2) {
                if (args[i2].startsWith("--")) {
                    if (args[i2].equals("--quiet")) {
                        script = false;
                        continue;
                    }
                    if (args[i2].equals("--drop")) {
                        drop = true;
                        continue;
                    }
                    if (args[i2].equals("--create")) {
                        create = true;
                        continue;
                    }
                    if (args[i2].equals("--haltonerror")) {
                        halt = true;
                        continue;
                    }
                    if (args[i2].equals("--text")) {
                        export = false;
                        continue;
                    }
                    if (args[i2].startsWith("--output=")) {
                        outFile = args[i2].substring(9);
                        continue;
                    }
                    if (args[i2].startsWith("--import=")) {
                        importFile = args[i2].substring(9);
                        continue;
                    }
                    if (args[i2].startsWith("--properties=")) {
                        propFile = args[i2].substring(13);
                        continue;
                    }
                    if (args[i2].equals("--format")) {
                        format = true;
                        continue;
                    }
                    if (args[i2].startsWith("--delimiter=")) {
                        delim = args[i2].substring(12);
                        continue;
                    }
                    if (args[i2].startsWith("--config=")) {
                        cfg.configure(args[i2].substring(9));
                        continue;
                    }
                    if (!args[i2].startsWith("--naming=")) continue;
                    cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(args[i2].substring(9)).newInstance());
                    continue;
                }
                String filename = args[i2];
                if (filename.endsWith(".jar")) {
                    cfg.addJar(new File(filename));
                    continue;
                }
                cfg.addFile(filename);
            }
            if (propFile != null) {
                Properties props = new Properties();
                props.putAll((Map<?, ?>)cfg.getProperties());
                props.load(new FileInputStream(propFile));
                cfg.setProperties(props);
            }
            SchemaExport se = new SchemaExport(cfg).setHaltOnError(halt).setOutputFile(outFile).setImportFile(importFile).setDelimiter(delim);
            if (format) {
                se.setFormat(true);
            }
            se.execute(script, export, drop, create);
        }
        catch (Exception e2) {
            log.error("Error creating schema ", e2);
            e2.printStackTrace();
        }
    }

    public List getExceptions() {
        return this.exceptions;
    }

    public SchemaExport setFormat(boolean format) {
        this.format = format;
        return this;
    }

    public SchemaExport setHaltOnError(boolean haltOnError) {
        this.haltOnError = haltOnError;
        return this;
    }
}

