/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.hbm2ddl;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.NamingStrategy;
import org.hibernate.tool.hbm2ddl.SchemaValidator;
import org.hibernate.util.ArrayHelper;
import org.hibernate.util.ReflectHelper;

public class SchemaValidatorTask
extends MatchingTask {
    private List fileSets = new LinkedList();
    private File propertiesFile = null;
    private File configurationFile = null;
    private String namingStrategy = null;

    public void addFileset(FileSet set) {
        this.fileSets.add(set);
    }

    public void setProperties(File propertiesFile) {
        if (!propertiesFile.exists()) {
            throw new BuildException("Properties file: " + propertiesFile + " does not exist.");
        }
        this.log("Using properties file " + propertiesFile, 4);
        this.propertiesFile = propertiesFile;
    }

    public void setConfig(File configurationFile) {
        this.configurationFile = configurationFile;
    }

    public void execute() throws BuildException {
        try {
            Configuration cfg = this.getConfiguration();
            this.getSchemaValidator(cfg).validate();
        }
        catch (HibernateException e2) {
            throw new BuildException("Schema text failed: " + e2.getMessage(), (Throwable)e2);
        }
        catch (FileNotFoundException e3) {
            throw new BuildException("File not found: " + e3.getMessage(), (Throwable)e3);
        }
        catch (IOException e4) {
            throw new BuildException("IOException : " + e4.getMessage(), (Throwable)e4);
        }
        catch (Exception e5) {
            throw new BuildException((Throwable)e5);
        }
    }

    private String[] getFiles() {
        LinkedList<String> files = new LinkedList<String>();
        Iterator i2 = this.fileSets.iterator();
        while (i2.hasNext()) {
            FileSet fs = (FileSet)i2.next();
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] dsFiles = ds.getIncludedFiles();
            for (int j2 = 0; j2 < dsFiles.length; ++j2) {
                File f2 = new File(dsFiles[j2]);
                if (!f2.isFile()) {
                    f2 = new File(ds.getBasedir(), dsFiles[j2]);
                }
                files.add(f2.getAbsolutePath());
            }
        }
        return ArrayHelper.toStringArray(files);
    }

    private Configuration getConfiguration() throws Exception {
        Configuration cfg = new Configuration();
        if (this.namingStrategy != null) {
            cfg.setNamingStrategy((NamingStrategy)ReflectHelper.classForName(this.namingStrategy).newInstance());
        }
        if (this.configurationFile != null) {
            cfg.configure(this.configurationFile);
        }
        String[] files = this.getFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            String filename = files[i2];
            if (filename.endsWith(".jar")) {
                cfg.addJar(new File(filename));
                continue;
            }
            cfg.addFile(filename);
        }
        return cfg;
    }

    private SchemaValidator getSchemaValidator(Configuration cfg) throws HibernateException, IOException {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)cfg.getProperties());
        if (this.propertiesFile == null) {
            properties.putAll((Map<?, ?>)this.getProject().getProperties());
        } else {
            properties.load(new FileInputStream(this.propertiesFile));
        }
        cfg.setProperties(properties);
        return new SchemaValidator(cfg);
    }

    public void setNamingStrategy(String namingStrategy) {
        this.namingStrategy = namingStrategy;
    }
}

