/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.collection.PersistentArrayHolder;
import org.hibernate.collection.PersistentCollection;
import org.hibernate.engine.SessionFactoryImplementor;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class ArrayType
extends CollectionType {
    private final Class elementClass;
    private final Class arrayClass;

    public ArrayType(String role, String propertyRef, Class elementClass, boolean isEmbeddedInXML) {
        super(role, propertyRef, isEmbeddedInXML);
        this.elementClass = elementClass;
        this.arrayClass = Array.newInstance(elementClass, 0).getClass();
    }

    public Class getReturnedClass() {
        return this.arrayClass;
    }

    public PersistentCollection instantiate(SessionImplementor session, CollectionPersister persister, Serializable key) throws HibernateException {
        return new PersistentArrayHolder(session, persister);
    }

    public Iterator getElementsIterator(Object collection) {
        return Arrays.asList((Object[])collection).iterator();
    }

    public PersistentCollection wrap(SessionImplementor session, Object array) {
        return new PersistentArrayHolder(session, array);
    }

    public boolean isArrayType() {
        return true;
    }

    public String toLoggableString(Object value, SessionFactoryImplementor factory) throws HibernateException {
        if (value == null) {
            return "null";
        }
        int length = Array.getLength(value);
        ArrayList<String> list = new ArrayList<String>(length);
        Type elemType = this.getElementType(factory);
        for (int i2 = 0; i2 < length; ++i2) {
            list.add(elemType.toLoggableString(Array.get(value, i2), factory));
        }
        return ((Object)list).toString();
    }

    public Object instantiateResult(Object original) {
        return Array.newInstance(this.elementClass, Array.getLength(original));
    }

    public Object replaceElements(Object original, Object target, Object owner, Map copyCache, SessionImplementor session) throws HibernateException {
        int length = Array.getLength(original);
        if (length != Array.getLength(target)) {
            target = this.instantiateResult(original);
        }
        Type elemType = this.getElementType(session.getFactory());
        for (int i2 = 0; i2 < length; ++i2) {
            Array.set(target, i2, elemType.replace(Array.get(original, i2), null, session, owner, copyCache));
        }
        return target;
    }

    public Object instantiate(int anticipatedSize) {
        throw new UnsupportedOperationException();
    }

    public Object indexOf(Object array, Object element) {
        int length = Array.getLength(array);
        for (int i2 = 0; i2 < length; ++i2) {
            if (Array.get(array, i2) != element) continue;
            return new Integer(i2);
        }
        return null;
    }

    protected boolean initializeImmediately(EntityMode entityMode) {
        return true;
    }

    public boolean hasHolder(EntityMode entityMode) {
        return true;
    }
}

