/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.type.ImmutableType;

public class TextType
extends ImmutableType {
    public void set(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        String str = (String)value;
        st.setCharacterStream(index, (Reader)new StringReader(str), str.length());
    }

    public Object get(ResultSet rs, String name) throws HibernateException, SQLException {
        Reader charReader = rs.getCharacterStream(name);
        if (charReader == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            int amountRead;
            char[] buffer = new char[2048];
            while ((amountRead = charReader.read(buffer, 0, buffer.length)) != -1) {
                sb.append(buffer, 0, amountRead);
            }
        }
        catch (IOException ioe) {
            throw new HibernateException("IOException occurred reading text", ioe);
        }
        finally {
            try {
                charReader.close();
            }
            catch (IOException e2) {
                throw new HibernateException("IOException occurred closing stream", e2);
            }
        }
        return sb.toString();
    }

    public int sqlType() {
        return 2005;
    }

    public Class getReturnedClass() {
        return String.class;
    }

    public String getName() {
        return "text";
    }

    public String toString(Object val) {
        return (String)val;
    }

    public Object fromStringValue(String xml) {
        return xml;
    }
}

