/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Comparator;
import java.util.Date;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.type.LiteralType;
import org.hibernate.type.MutableType;
import org.hibernate.type.VersionType;
import org.hibernate.util.ComparableComparator;

public class TimestampType
extends MutableType
implements VersionType,
LiteralType {
    private static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public Object get(ResultSet rs, String name) throws SQLException {
        return rs.getTimestamp(name);
    }

    public Class getReturnedClass() {
        return Date.class;
    }

    public void set(PreparedStatement st, Object value, int index) throws SQLException {
        Timestamp ts = value instanceof Timestamp ? (Timestamp)value : new Timestamp(((Date)value).getTime());
        st.setTimestamp(index, ts);
    }

    public int sqlType() {
        return 93;
    }

    public String getName() {
        return "timestamp";
    }

    public String toString(Object val) {
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format((Date)val);
    }

    public Object deepCopyNotNull(Object value) {
        if (value instanceof Timestamp) {
            Timestamp orig = (Timestamp)value;
            Timestamp ts = new Timestamp(orig.getTime());
            ts.setNanos(orig.getNanos());
            return ts;
        }
        Date orig = (Date)value;
        return new Date(orig.getTime());
    }

    public boolean isEqual(Object x, Object y) {
        int yNanos;
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        long xTime = ((Date)x).getTime();
        long yTime = ((Date)y).getTime();
        boolean xts = x instanceof Timestamp;
        boolean yts = y instanceof Timestamp;
        int xNanos = xts ? ((Timestamp)x).getNanos() : 0;
        int n2 = yNanos = yts ? ((Timestamp)y).getNanos() : 0;
        if (!Environment.jvmHasJDK14Timestamp()) {
            xTime += (long)(xNanos / 1000000);
            yTime += (long)(yNanos / 1000000);
        }
        if (xTime != yTime) {
            return false;
        }
        if (xts && yts) {
            int xn = xNanos % 1000000;
            int yn = yNanos % 1000000;
            return xn == yn;
        }
        return true;
    }

    public int getHashCode(Object x, EntityMode entityMode) {
        Date ts = (Date)x;
        return new Long(ts.getTime() / 1000L).hashCode();
    }

    public Object next(Object current, SessionImplementor session) {
        return this.seed(session);
    }

    public Object seed(SessionImplementor session) {
        return new Timestamp(System.currentTimeMillis());
    }

    public Comparator getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public String objectToSQLString(Object value, Dialect dialect) throws Exception {
        return '\'' + new Timestamp(((Date)value).getTime()).toString() + '\'';
    }

    public Object fromStringValue(String xml) throws HibernateException {
        try {
            return new Timestamp(new SimpleDateFormat(TIMESTAMP_FORMAT).parse(xml).getTime());
        }
        catch (ParseException pe) {
            throw new HibernateException("could not parse XML", pe);
        }
    }
}

