/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.PropertyNotFoundException;
import org.hibernate.property.BasicPropertyAccessor;
import org.hibernate.property.DirectPropertyAccessor;
import org.hibernate.property.Getter;
import org.hibernate.property.PropertyAccessor;
import org.hibernate.type.PrimitiveType;
import org.hibernate.type.Type;
import org.hibernate.util.StringHelper;

public final class ReflectHelper {
    private static final PropertyAccessor BASIC_PROPERTY_ACCESSOR;
    private static final PropertyAccessor DIRECT_PROPERTY_ACCESSOR;
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    private static final Class[] NO_PARAM;
    private static final Method OBJECT_HASHCODE;

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static boolean overridesHashCode(Class clazz) {
        Method hashCode;
        try {
            hashCode = clazz.getMethod("hashCode", NO_PARAM);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_HASHCODE.equals(hashCode);
    }

    public static Class reflectedPropertyClass(String className, String name) throws MappingException {
        try {
            Class clazz = ReflectHelper.classForName(className);
            return ReflectHelper.getter(clazz, name).getReturnType();
        }
        catch (ClassNotFoundException cnfe) {
            throw new MappingException("class " + className + " not found while looking for property: " + name, cnfe);
        }
    }

    private static Getter getter(Class clazz, String name) throws MappingException {
        try {
            return BASIC_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
        catch (PropertyNotFoundException pnfe) {
            return DIRECT_PROPERTY_ACCESSOR.getGetter(clazz, name);
        }
    }

    public static Getter getGetter(Class theClass, String name) throws MappingException {
        return BASIC_PROPERTY_ACCESSOR.getGetter(theClass, name);
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name);
    }

    public static Class classForName(String name, Class caller) throws ClassNotFoundException {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader.loadClass(name);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Class.forName(name, true, caller.getClassLoader());
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (Throwable t) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static boolean isFinalClass(Class clazz) {
        return Modifier.isFinal(clazz.getModifiers());
    }

    public static Constructor getConstructor(Class clazz, Type[] types) throws PropertyNotFoundException {
        Constructor<?>[] candidates = clazz.getConstructors();
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            Constructor<?> constructor = candidates[i2];
            Class<?>[] params = constructor.getParameterTypes();
            if (params.length != types.length) continue;
            boolean found = true;
            for (int j2 = 0; j2 < params.length; ++j2) {
                boolean ok;
                boolean bl = ok = params[j2].isAssignableFrom(types[j2].getReturnedClass()) || types[j2] instanceof PrimitiveType && params[j2] == ((PrimitiveType)types[j2]).getPrimitiveClass();
                if (ok) continue;
                found = false;
                break;
            }
            if (!found) continue;
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        throw new PropertyNotFoundException("no appropriate constructor in class: " + clazz.getName());
    }

    public static Method getMethod(Class clazz, Method method) {
        try {
            return clazz.getMethod(method.getName(), method.getParameterTypes());
        }
        catch (Exception e2) {
            return null;
        }
    }

    private ReflectHelper() {
    }

    static {
        Method hash;
        Method eq;
        BASIC_PROPERTY_ACCESSOR = new BasicPropertyAccessor();
        DIRECT_PROPERTY_ACCESSOR = new DirectPropertyAccessor();
        NO_CLASSES = new Class[0];
        OBJECT = new Class[]{Object.class};
        NO_PARAM = new Class[0];
        try {
            eq = Object.class.getMethod("equals", OBJECT);
            hash = Object.class.getMethod("hashCode", NO_PARAM);
        }
        catch (Exception e2) {
            throw new AssertionFailure("Could not find Object.equals() or Object.hashCode()", e2);
        }
        OBJECT_EQUALS = eq;
        OBJECT_HASHCODE = hash;
    }
}

