/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.hibernate.util.ArrayHelper;

public final class StringHelper {
    private static final int ALIAS_TRUNCATE_LENGTH = 10;
    public static final String WHITESPACE = " \n\r\f\t";

    private StringHelper() {
    }

    public static int lastIndexOfLetter(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char character = string.charAt(i2);
            if (Character.isLetter(character)) continue;
            return i2 - 1;
        }
        return string.length() - 1;
    }

    public static String join(String seperator, String[] strings) {
        int length = strings.length;
        if (length == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(length * strings[0].length()).append(strings[0]);
        for (int i2 = 1; i2 < length; ++i2) {
            buf.append(seperator).append(strings[i2]);
        }
        return buf.toString();
    }

    public static String join(String seperator, Iterator objects) {
        StringBuffer buf = new StringBuffer();
        if (objects.hasNext()) {
            buf.append(objects.next());
        }
        while (objects.hasNext()) {
            buf.append(seperator).append(objects.next());
        }
        return buf.toString();
    }

    public static String[] add(String[] x, String sep, String[] y) {
        String[] result = new String[x.length];
        for (int i2 = 0; i2 < x.length; ++i2) {
            result[i2] = x[i2] + sep + y[i2];
        }
        return result;
    }

    public static String repeat(String string, int times) {
        StringBuffer buf = new StringBuffer(string.length() * times);
        for (int i2 = 0; i2 < times; ++i2) {
            buf.append(string);
        }
        return buf.toString();
    }

    public static String replace(String template, String placeholder, String replacement) {
        return StringHelper.replace(template, placeholder, replacement, false);
    }

    public static String[] replace(String[] templates, String placeholder, String replacement) {
        String[] result = new String[templates.length];
        for (int i2 = 0; i2 < templates.length; ++i2) {
            result[i2] = StringHelper.replace(templates[i2], placeholder, replacement);
        }
        return result;
    }

    public static String replace(String template, String placeholder, String replacement, boolean wholeWords) {
        int loc;
        int n2 = loc = template == null ? -1 : template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        boolean actuallyReplace = !wholeWords || loc + placeholder.length() == template.length() || !Character.isJavaIdentifierPart(template.charAt(loc + placeholder.length()));
        String actualReplacement = actuallyReplace ? replacement : placeholder;
        return template.substring(0, loc) + actualReplacement + StringHelper.replace(template.substring(loc + placeholder.length()), placeholder, replacement, wholeWords);
    }

    public static String replaceOnce(String template, String placeholder, String replacement) {
        int loc;
        int n2 = loc = template == null ? -1 : template.indexOf(placeholder);
        if (loc < 0) {
            return template;
        }
        return template.substring(0, loc) + replacement + template.substring(loc + placeholder.length());
    }

    public static String[] split(String seperators, String list) {
        return StringHelper.split(seperators, list, false);
    }

    public static String[] split(String seperators, String list, boolean include) {
        StringTokenizer tokens = new StringTokenizer(list, seperators, include);
        String[] result = new String[tokens.countTokens()];
        int i2 = 0;
        while (tokens.hasMoreTokens()) {
            result[i2++] = tokens.nextToken();
        }
        return result;
    }

    public static String unqualify(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
    }

    public static String qualifier(String qualifiedName) {
        int loc = qualifiedName.lastIndexOf(".");
        return loc < 0 ? "" : qualifiedName.substring(0, loc);
    }

    public static String[] suffix(String[] columns, String suffix) {
        if (suffix == null) {
            return columns;
        }
        String[] qualified = new String[columns.length];
        for (int i2 = 0; i2 < columns.length; ++i2) {
            qualified[i2] = StringHelper.suffix(columns[i2], suffix);
        }
        return qualified;
    }

    private static String suffix(String name, String suffix) {
        return suffix == null ? name : name + suffix;
    }

    public static String root(String qualifiedName) {
        int loc = qualifiedName.indexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(0, loc);
    }

    public static String unroot(String qualifiedName) {
        int loc = qualifiedName.indexOf(".");
        return loc < 0 ? qualifiedName : qualifiedName.substring(loc + 1, qualifiedName.length());
    }

    public static boolean booleanValue(String tfString) {
        String trimmed = tfString.trim().toLowerCase();
        return trimmed.equals("true") || trimmed.equals("t");
    }

    public static String toString(Object[] array) {
        int len = array.length;
        if (len == 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(len * 12);
        for (int i2 = 0; i2 < len - 1; ++i2) {
            buf.append(array[i2]).append(", ");
        }
        return buf.append(array[len - 1]).toString();
    }

    public static String[] multiply(String string, Iterator placeholders, Iterator replacements) {
        String[] result = new String[]{string};
        while (placeholders.hasNext()) {
            result = StringHelper.multiply(result, (String)placeholders.next(), (String[])replacements.next());
        }
        return result;
    }

    private static String[] multiply(String[] strings, String placeholder, String[] replacements) {
        String[] results = new String[replacements.length * strings.length];
        int n2 = 0;
        for (int i2 = 0; i2 < replacements.length; ++i2) {
            for (int j2 = 0; j2 < strings.length; ++j2) {
                results[n2++] = StringHelper.replaceOnce(strings[j2], placeholder, replacements[i2]);
            }
        }
        return results;
    }

    public static int countUnquoted(String string, char character) {
        if ('\'' == character) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return 0;
        }
        int count = 0;
        int stringLength = string.length();
        boolean inQuote = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            char c2 = string.charAt(indx);
            if (inQuote) {
                if ('\'' != c2) continue;
                inQuote = false;
                continue;
            }
            if ('\'' == c2) {
                inQuote = true;
                continue;
            }
            if (c2 != character) continue;
            ++count;
        }
        return count;
    }

    public static int[] locateUnquoted(String string, char character) {
        if ('\'' == character) {
            throw new IllegalArgumentException("Unquoted count of quotes is invalid");
        }
        if (string == null) {
            return new int[0];
        }
        ArrayList<Integer> locations = new ArrayList<Integer>(20);
        int stringLength = string.length();
        boolean inQuote = false;
        for (int indx = 0; indx < stringLength; ++indx) {
            char c2 = string.charAt(indx);
            if (inQuote) {
                if ('\'' != c2) continue;
                inQuote = false;
                continue;
            }
            if ('\'' == c2) {
                inQuote = true;
                continue;
            }
            if (c2 != character) continue;
            locations.add(new Integer(indx));
        }
        return ArrayHelper.toIntArray(locations);
    }

    public static boolean isNotEmpty(String string) {
        return string != null && string.length() > 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static String qualify(String prefix, String name) {
        if (name == null || prefix == null) {
            throw new NullPointerException();
        }
        return new StringBuffer(prefix.length() + name.length() + 1).append(prefix).append('.').append(name).toString();
    }

    public static String[] qualify(String prefix, String[] names) {
        if (prefix == null) {
            return names;
        }
        int len = names.length;
        String[] qualified = new String[len];
        for (int i2 = 0; i2 < len; ++i2) {
            qualified[i2] = StringHelper.qualify(prefix, names[i2]);
        }
        return qualified;
    }

    public static int firstIndexOfChar(String sqlString, String string, int startindex) {
        int matchAt = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            int curMatch = sqlString.indexOf(string.charAt(i2), startindex);
            if (curMatch < 0) continue;
            matchAt = matchAt == -1 ? curMatch : Math.min(matchAt, curMatch);
        }
        return matchAt;
    }

    public static String truncate(String string, int length) {
        if (string.length() <= length) {
            return string;
        }
        return string.substring(0, length);
    }

    public static String generateAlias(String description) {
        return StringHelper.generateAliasRoot(description) + '_';
    }

    public static String generateAlias(String description, int unique) {
        return StringHelper.generateAliasRoot(description) + Integer.toString(unique) + '_';
    }

    private static String generateAliasRoot(String description) {
        String result = StringHelper.truncate(StringHelper.unqualifyEntityName(description), 10).toLowerCase().replace('/', '_').replace('$', '_');
        if (Character.isDigit((result = StringHelper.cleanAlias(result)).charAt(result.length() - 1))) {
            return result + "x";
        }
        return result;
    }

    private static String cleanAlias(String alias) {
        char[] chars = alias.toCharArray();
        if (!Character.isLetter(chars[0])) {
            for (int i2 = 1; i2 < chars.length; ++i2) {
                if (!Character.isLetter(chars[i2])) continue;
                return alias.substring(i2);
            }
        }
        return alias;
    }

    public static String unqualifyEntityName(String entityName) {
        String result = StringHelper.unqualify(entityName);
        int slashPos = result.indexOf(47);
        if (slashPos > 0) {
            result = result.substring(0, slashPos - 1);
        }
        return result;
    }

    public static String toUpperCase(String str) {
        return str == null ? null : str.toUpperCase();
    }

    public static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    public static String moveAndToBeginning(String filter) {
        if (filter.trim().length() > 0 && (filter = filter + " and ").startsWith(" and ")) {
            filter = filter.substring(4);
        }
        return filter;
    }
}

