/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data;

import org.jfree.data.DefaultKeyedValues;
import org.jfree.data.KeyedValues;
import org.jfree.data.Values2D;

public abstract class DataUtilities {
    public static double calculateColumnTotal(Values2D data, int column) {
        double total = 0.0;
        int rowCount = data.getRowCount();
        for (int r = 0; r < rowCount; ++r) {
            Number n2 = data.getValue(r, column);
            if (n2 == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static double calculateRowTotal(Values2D data, int row) {
        double total = 0.0;
        int columnCount = data.getColumnCount();
        for (int c2 = 0; c2 < columnCount; ++c2) {
            Number n2 = data.getValue(row, c2);
            if (n2 == null) continue;
            total += n2.doubleValue();
        }
        return total;
    }

    public static Number[] createNumberArray(double[] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        Number[] result = new Number[data.length];
        for (int i2 = 0; i2 < data.length; ++i2) {
            result[i2] = new Double(data[i2]);
        }
        return result;
    }

    public static Number[][] createNumberArray2D(double[][] data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        int l1 = data.length;
        Number[][] result = new Number[l1][];
        for (int i2 = 0; i2 < l1; ++i2) {
            result[i2] = DataUtilities.createNumberArray(data[i2]);
        }
        return result;
    }

    public static KeyedValues getCumulativePercentages(KeyedValues data) {
        if (data == null) {
            throw new IllegalArgumentException("Null 'data' argument.");
        }
        DefaultKeyedValues result = new DefaultKeyedValues();
        double total = 0.0;
        for (int i2 = 0; i2 < data.getItemCount(); ++i2) {
            Number v = data.getValue(i2);
            if (v == null) continue;
            total += v.doubleValue();
        }
        double runningTotal = 0.0;
        for (int i3 = 0; i3 < data.getItemCount(); ++i3) {
            Number v = data.getValue(i3);
            if (v != null) {
                runningTotal += v.doubleValue();
            }
            result.addValue(data.getKey(i3), new Double(runningTotal / total));
        }
        return result;
    }
}

