/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jfree.ui.NumberCellRenderer;
import org.jfree.util.Log;
import org.jfree.util.LogContext;

public abstract class RefineryUtilities {
    protected static final LogContext logger = Log.createContext(class$org$jfree$ui$RefineryUtilities == null ? (class$org$jfree$ui$RefineryUtilities = RefineryUtilities.class$("org.jfree.ui.RefineryUtilities")) : class$org$jfree$ui$RefineryUtilities);
    static /* synthetic */ Class class$org$jfree$ui$RefineryUtilities;
    static /* synthetic */ Class class$java$lang$Number;

    public static void centerFrameOnScreen(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, 0.5, 0.5);
    }

    public static void positionFrameOnScreen(Window frame, double horizontalPercent, double verticalPercent) {
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension f2 = frame.getSize();
        int w = Math.max(s.width - f2.width, 0);
        int h2 = Math.max(s.height - f2.height, 0);
        int x = (int)(horizontalPercent * (double)w);
        int y = (int)(verticalPercent * (double)h2);
        frame.setBounds(x, y, f2.width, f2.height);
    }

    public static void positionFrameRandomly(Window frame) {
        RefineryUtilities.positionFrameOnScreen(frame, Math.random(), Math.random());
    }

    public static void centerDialogInParent(Dialog dialog) {
        RefineryUtilities.positionDialogRelativeToParent(dialog, 0.5, 0.5);
    }

    public static void positionDialogRelativeToParent(Dialog dialog, double horizontalPercent, double verticalPercent) {
        Dimension d2 = dialog.getSize();
        Container parent = dialog.getParent();
        Dimension p = parent.getSize();
        int baseX = parent.getX() - d2.width;
        int baseY = parent.getY() - d2.height;
        int w = d2.width + p.width;
        int h2 = d2.height + p.height;
        int x = baseX + (int)(horizontalPercent * (double)w);
        int y = baseY + (int)(verticalPercent * (double)h2);
        Dimension s = Toolkit.getDefaultToolkit().getScreenSize();
        x = Math.min(x, s.width - d2.width);
        x = Math.max(x, 0);
        y = Math.min(y, s.height - d2.height);
        y = Math.max(y, 0);
        dialog.setBounds(x, y, d2.width, d2.height);
    }

    public static JPanel createTablePanel(TableModel model) {
        JPanel panel = new JPanel(new BorderLayout());
        JTable table = new JTable(model);
        for (int columnIndex = 0; columnIndex < model.getColumnCount(); ++columnIndex) {
            TableColumn column = table.getColumnModel().getColumn(columnIndex);
            Class<?> c2 = model.getColumnClass(columnIndex);
            if (!c2.equals(class$java$lang$Number == null ? RefineryUtilities.class$("java.lang.Number") : class$java$lang$Number)) continue;
            column.setCellRenderer(new NumberCellRenderer());
        }
        panel.add(new JScrollPane(table));
        return panel;
    }

    public static JLabel createJLabel(String text, Font font) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        return result;
    }

    public static JLabel createJLabel(String text, Font font, Color color) {
        JLabel result = new JLabel(text);
        result.setFont(font);
        result.setForeground(color);
        return result;
    }

    public static JButton createJButton(String label, Font font) {
        JButton result = new JButton(label);
        result.setFont(font);
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

