/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util;

import java.util.Arrays;

public class ArrayUtilities {
    private ArrayUtilities() {
    }

    public static float[][] clone(float[][] array) {
        if (array == null) {
            return null;
        }
        float[][] result = new float[array.length][];
        System.arraycopy(array, 0, result, 0, array.length);
        for (int i2 = 0; i2 < array.length; ++i2) {
            float[] child = array[i2];
            float[] copychild = new float[child.length];
            System.arraycopy(child, 0, copychild, 0, child.length);
            result[i2] = copychild;
        }
        return result;
    }

    public static boolean equalReferencesInArrays(Object[] array1, Object[] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (array1[i2] == null && array2[i2] != null) {
                return false;
            }
            if (array2[i2] == null && array1[i2] != null) {
                return false;
            }
            if (array1[i2] == array2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean equal(float[][] array1, float[][] array2) {
        if (array1 == null) {
            return array2 == null;
        }
        if (array2 == null) {
            return false;
        }
        if (array1.length != array2.length) {
            return false;
        }
        for (int i2 = 0; i2 < array1.length; ++i2) {
            if (Arrays.equals(array1[i2], array2[i2])) continue;
            return false;
        }
        return true;
    }

    public static boolean hasDuplicateItems(Object[] array) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            for (int j2 = 0; j2 < i2; ++j2) {
                Object o1 = array[i2];
                Object o2 = array[j2];
                if (o1 == null || o2 == null || !o1.equals(o2)) continue;
                return true;
            }
        }
        return false;
    }
}

