/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Exp
extends PostfixMathCommand {
    public Exp() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.exp(e2));
    }

    public Object exp(Object object) throws ParseException {
        if (object instanceof Complex) {
            Complex complex = (Complex)object;
            double d2 = complex.re();
            double d3 = complex.im();
            double d4 = Math.exp(d2);
            return new Complex(d4 * Math.cos(d3), d4 * Math.sin(d3));
        }
        if (object instanceof Number) {
            return new Double(Math.exp(((Number)object).doubleValue()));
        }
        throw new ParseException("Invalid parameter type");
    }
}

