/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Power
extends PostfixMathCommand {
    public Power() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        Object e3 = stack.pop();
        stack.push(this.power(e3, e2));
    }

    public Object power(Object object, Object object2) throws ParseException {
        if (object instanceof Complex) {
            if (object2 instanceof Complex) {
                return this.power((Complex)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.power((Complex)object, (Number)object2);
            }
        } else if (object instanceof Number) {
            if (object2 instanceof Complex) {
                return this.power((Number)object, (Complex)object2);
            }
            if (object2 instanceof Number) {
                return this.power((Number)object, (Number)object2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Object power(Number number, Number number2) {
        if (number.doubleValue() < 0.0 && number2.doubleValue() != (double)number2.intValue()) {
            Complex complex = new Complex(number.doubleValue(), 0.0);
            return complex.power(number2.doubleValue());
        }
        return new Double(Math.pow(number.doubleValue(), number2.doubleValue()));
    }

    public Object power(Complex complex, Complex complex2) {
        Complex complex3 = complex.power(complex2);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }

    public Object power(Complex complex, Number number) {
        Complex complex2 = complex.power(number.doubleValue());
        if (complex2.im() == 0.0) {
            return new Double(complex2.re());
        }
        return complex2;
    }

    public Object power(Number number, Complex complex) {
        Complex complex2 = new Complex(number.doubleValue(), 0.0);
        Complex complex3 = complex2.power(complex);
        if (complex3.im() == 0.0) {
            return new Double(complex3.re());
        }
        return complex3;
    }
}

