/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class SquareRoot
extends PostfixMathCommand {
    public SquareRoot() {
        this.numberOfParameters = 1;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object e2 = stack.pop();
        stack.push(this.sqrt(e2));
    }

    public Object sqrt(Object object) throws ParseException {
        if (object instanceof Complex) {
            return ((Complex)object).sqrt();
        }
        if (object instanceof Number) {
            double d2 = ((Number)object).doubleValue();
            if (d2 < 0.0) {
                return new Complex(d2).sqrt();
            }
            return new Double(Math.sqrt(d2));
        }
        throw new ParseException("Invalid parameter type");
    }
}

