/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

public class ByteVector {
    byte[] data;
    int length;

    public ByteVector() {
        this.data = new byte[64];
    }

    public ByteVector(int n2) {
        this.data = new byte[n2];
    }

    public ByteVector putByte(int n2) {
        int n3 = this.length;
        if (n3 + 1 > this.data.length) {
            this.enlarge(1);
        }
        this.data[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    ByteVector put11(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putShort(int n2) {
        int n3 = this.length;
        if (n3 + 2 > this.data.length) {
            this.enlarge(2);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    ByteVector put12(int n2, int n3) {
        int n4 = this.length;
        if (n4 + 3 > this.data.length) {
            this.enlarge(3);
        }
        byte[] byArray = this.data;
        byArray[n4++] = (byte)n2;
        byArray[n4++] = (byte)(n3 >>> 8);
        byArray[n4++] = (byte)n3;
        this.length = n4;
        return this;
    }

    public ByteVector putInt(int n2) {
        int n3 = this.length;
        if (n3 + 4 > this.data.length) {
            this.enlarge(4);
        }
        byte[] byArray = this.data;
        byArray[n3++] = (byte)(n2 >>> 24);
        byArray[n3++] = (byte)(n2 >>> 16);
        byArray[n3++] = (byte)(n2 >>> 8);
        byArray[n3++] = (byte)n2;
        this.length = n3;
        return this;
    }

    public ByteVector putLong(long l2) {
        int n2 = this.length;
        if (n2 + 8 > this.data.length) {
            this.enlarge(8);
        }
        byte[] byArray = this.data;
        int n3 = (int)(l2 >>> 32);
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        n3 = (int)l2;
        byArray[n2++] = (byte)(n3 >>> 24);
        byArray[n2++] = (byte)(n3 >>> 16);
        byArray[n2++] = (byte)(n3 >>> 8);
        byArray[n2++] = (byte)n3;
        this.length = n2;
        return this;
    }

    public ByteVector putUTF8(String string) {
        int n2;
        int n3 = string.length();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            char c2 = string.charAt(n2);
            if (c2 >= '\u0001' && c2 <= '\u007f') {
                ++n4;
                continue;
            }
            if (c2 > '\u07ff') {
                n4 += 3;
                continue;
            }
            n4 += 2;
        }
        if (n4 > 65535) {
            throw new IllegalArgumentException();
        }
        n2 = this.length;
        if (n2 + 2 + n4 > this.data.length) {
            this.enlarge(2 + n4);
        }
        byte[] byArray = this.data;
        byArray[n2++] = (byte)(n4 >>> 8);
        byArray[n2++] = (byte)n4;
        for (int i2 = 0; i2 < n3; ++i2) {
            char c3 = string.charAt(i2);
            if (c3 >= '\u0001' && c3 <= '\u007f') {
                byArray[n2++] = (byte)c3;
                continue;
            }
            if (c3 > '\u07ff') {
                byArray[n2++] = (byte)(0xE0 | c3 >> 12 & 0xF);
                byArray[n2++] = (byte)(0x80 | c3 >> 6 & 0x3F);
                byArray[n2++] = (byte)(0x80 | c3 & 0x3F);
                continue;
            }
            byArray[n2++] = (byte)(0xC0 | c3 >> 6 & 0x1F);
            byArray[n2++] = (byte)(0x80 | c3 & 0x3F);
        }
        this.length = n2;
        return this;
    }

    public ByteVector putByteArray(byte[] byArray, int n2, int n3) {
        if (this.length + n3 > this.data.length) {
            this.enlarge(n3);
        }
        if (byArray != null) {
            System.arraycopy(byArray, n2, this.data, this.length, n3);
        }
        this.length += n3;
        return this;
    }

    private void enlarge(int n2) {
        int n3 = 2 * this.data.length;
        int n4 = this.length + n2;
        byte[] byArray = new byte[n3 > n4 ? n3 : n4];
        System.arraycopy(this.data, 0, byArray, 0, this.length);
        this.data = byArray;
    }
}

