/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.io.IOException;
import java.io.InputStream;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

public class ClassReader {
    public final byte[] b;
    private int[] items;
    private String[] strings;
    private int maxStringLength;
    private int header;

    public ClassReader(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ClassReader(byte[] byArray, int n2, int n3) {
        this.b = byArray;
        this.items = new int[this.readUnsignedShort(n2 + 8)];
        this.strings = new String[this.items.length];
        int n4 = 0;
        int n5 = n2 + 10;
        for (int i2 = 1; i2 < this.items.length; ++i2) {
            int n6;
            this.items[i2] = n5 + 1;
            byte by = byArray[n5];
            switch (by) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    n6 = 5;
                    break;
                }
                case 5: 
                case 6: {
                    n6 = 9;
                    ++i2;
                    break;
                }
                case 1: {
                    n6 = 3 + this.readUnsignedShort(n5 + 1);
                    n4 = n6 > n4 ? n6 : n4;
                    break;
                }
                default: {
                    n6 = 3;
                }
            }
            n5 += n6;
        }
        this.maxStringLength = n4;
        this.header = n5;
    }

    public ClassReader(InputStream inputStream) throws IOException {
        this(ClassReader.readClass(inputStream));
    }

    public ClassReader(String string) throws IOException {
        this(ClassLoader.getSystemResourceAsStream(string.replace('.', '/') + ".class"));
    }

    private static byte[] readClass(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IOException("Class not found");
        }
        byte[] byArray = new byte[inputStream.available()];
        int n2 = 0;
        while (true) {
            byte[] byArray2;
            int n3;
            if ((n3 = inputStream.read(byArray, n2, byArray.length - n2)) == -1) {
                if (n2 < byArray.length) {
                    byArray2 = new byte[n2];
                    System.arraycopy(byArray, 0, byArray2, 0, n2);
                    byArray = byArray2;
                }
                return byArray;
            }
            if ((n2 += n3) != byArray.length) continue;
            byArray2 = new byte[byArray.length + 1000];
            System.arraycopy(byArray, 0, byArray2, 0, n2);
            byArray = byArray2;
        }
    }

    public void accept(ClassVisitor classVisitor, boolean bl) {
        this.accept(classVisitor, new Attribute[0], bl);
    }

    public void accept(ClassVisitor classVisitor, Attribute[] attributeArray, boolean bl) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        int n2;
        int n3;
        byte[] byArray = this.b;
        char[] cArray = new char[this.maxStringLength];
        int n4 = this.header;
        int n5 = this.readInt(4);
        int n6 = this.readUnsignedShort(n4);
        String string = this.readClass(n4 + 2, cArray);
        int n7 = this.items[this.readUnsignedShort(n4 + 4)];
        String string2 = n7 == 0 ? null : this.readUTF8(n7, cArray);
        String[] stringArray2 = new String[this.readUnsignedShort(n4 + 6)];
        String string3 = null;
        Object object5 = null;
        int n8 = 0;
        n4 += 8;
        for (n3 = 0; n3 < stringArray2.length; ++n3) {
            stringArray2[n3] = this.readClass(n4, cArray);
            n4 += 2;
        }
        n7 = n4;
        n3 = this.readUnsignedShort(n7);
        n7 += 2;
        while (n3 > 0) {
            n2 = this.readUnsignedShort(n7 + 6);
            n7 += 8;
            while (n2 > 0) {
                n7 += 6 + this.readInt(n7 + 2);
                --n2;
            }
            --n3;
        }
        n3 = this.readUnsignedShort(n7);
        n7 += 2;
        while (n3 > 0) {
            n2 = this.readUnsignedShort(n7 + 6);
            n7 += 8;
            while (n2 > 0) {
                n7 += 6 + this.readInt(n7 + 2);
                --n2;
            }
            --n3;
        }
        n3 = this.readUnsignedShort(n7);
        n7 += 2;
        while (n3 > 0) {
            object4 = this.readUTF8(n7, cArray);
            if (((String)object4).equals("SourceFile")) {
                string3 = this.readUTF8(n7 + 6, cArray);
            } else if (((String)object4).equals("Deprecated")) {
                n6 |= 0x20000;
            } else if (((String)object4).equals("Synthetic")) {
                n6 |= 0x1000;
            } else if (((String)object4).equals("InnerClasses")) {
                n8 = n7 + 6;
            } else {
                object3 = this.readAttribute(attributeArray, (String)object4, n7 + 6, this.readInt(n7 + 2), cArray, -1, null);
                if (object3 != null) {
                    ((Attribute)object3).next = object5;
                    object5 = object3;
                }
            }
            n7 += 6 + this.readInt(n7 + 2);
            --n3;
        }
        classVisitor.visit(n5, n6, string, string2, stringArray2, string3);
        if (n8 != 0) {
            n3 = this.readUnsignedShort(n8);
            n8 += 2;
            while (n3 > 0) {
                classVisitor.visitInnerClass(this.readUnsignedShort(n8) == 0 ? null : this.readClass(n8, cArray), this.readUnsignedShort(n8 + 2) == 0 ? null : this.readClass(n8 + 2, cArray), this.readUnsignedShort(n8 + 4) == 0 ? null : this.readUTF8(n8 + 4, cArray), this.readUnsignedShort(n8 + 6));
                n8 += 8;
                --n3;
            }
        }
        n3 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n3 > 0) {
            n6 = this.readUnsignedShort(n4);
            object4 = this.readUTF8(n4 + 2, cArray);
            object2 = this.readUTF8(n4 + 4, cArray);
            object = null;
            int n9 = 0;
            n2 = this.readUnsignedShort(n4 + 6);
            n4 += 8;
            while (n2 > 0) {
                stringArray = this.readUTF8(n4, cArray);
                if (stringArray.equals("ConstantValue")) {
                    n9 = this.readUnsignedShort(n4 + 6);
                } else if (stringArray.equals("Synthetic")) {
                    n6 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n6 |= 0x20000;
                } else {
                    object3 = this.readAttribute(attributeArray, (String)stringArray, n4 + 6, this.readInt(n4 + 2), cArray, -1, null);
                    if (object3 != null) {
                        ((Attribute)object3).next = object;
                        object = object3;
                    }
                }
                n4 += 6 + this.readInt(n4 + 2);
                --n2;
            }
            stringArray = n9 == 0 ? null : this.readConst(n9, cArray);
            classVisitor.visitField(n6, (String)object4, (String)object2, stringArray, (Attribute)object);
            --n3;
        }
        n3 = this.readUnsignedShort(n4);
        n4 += 2;
        while (n3 > 0) {
            n6 = this.readUnsignedShort(n4);
            object4 = this.readUTF8(n4 + 2, cArray);
            object2 = this.readUTF8(n4 + 4, cArray);
            object = null;
            Object object6 = null;
            n7 = 0;
            n8 = 0;
            n2 = this.readUnsignedShort(n4 + 6);
            n4 += 8;
            while (n2 > 0) {
                stringArray = this.readUTF8(n4, cArray);
                int n10 = this.readInt(n4 += 2);
                n4 += 4;
                if (stringArray.equals("Code")) {
                    n7 = n4;
                } else if (stringArray.equals("Exceptions")) {
                    n8 = n4;
                } else if (stringArray.equals("Synthetic")) {
                    n6 |= 0x1000;
                } else if (stringArray.equals("Deprecated")) {
                    n6 |= 0x20000;
                } else {
                    object3 = this.readAttribute(attributeArray, (String)stringArray, n4, n10, cArray, -1, null);
                    if (object3 != null) {
                        ((Attribute)object3).next = object;
                        object = object3;
                    }
                }
                n4 += n10;
                --n2;
            }
            if (n8 == 0) {
                stringArray = null;
            } else {
                stringArray = new String[this.readUnsignedShort(n8)];
                n8 += 2;
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    stringArray[n2] = this.readClass(n8, cArray);
                    n8 += 2;
                }
            }
            CodeVisitor codeVisitor = classVisitor.visitMethod(n6, (String)object4, (String)object2, stringArray, (Attribute)object);
            if (codeVisitor != null && n7 != 0) {
                int n11;
                int n12;
                int n13 = this.readUnsignedShort(n7);
                int n14 = this.readUnsignedShort(n7 + 2);
                int n15 = this.readInt(n7 + 4);
                int n16 = n7 += 8;
                int n17 = n7 + n15;
                Label[] labelArray = new Label[n15 + 1];
                block40: while (n7 < n17) {
                    int n18 = byArray[n7] & 0xFF;
                    switch (ClassWriter.TYPE[n18]) {
                        case 0: 
                        case 4: {
                            ++n7;
                            continue block40;
                        }
                        case 8: {
                            n12 = n7 - n16 + this.readShort(n7 + 1);
                            if (labelArray[n12] == null) {
                                labelArray[n12] = new Label();
                            }
                            n7 += 3;
                            continue block40;
                        }
                        case 9: {
                            n12 = n7 - n16 + this.readInt(n7 + 1);
                            if (labelArray[n12] == null) {
                                labelArray[n12] = new Label();
                            }
                            n7 += 5;
                            continue block40;
                        }
                        case 16: {
                            n18 = byArray[n7 + 1] & 0xFF;
                            if (n18 == 132) {
                                n7 += 6;
                                continue block40;
                            }
                            n7 += 4;
                            continue block40;
                        }
                        case 13: {
                            n8 = n7 - n16;
                            n7 = n7 + 4 - (n8 & 3);
                            n12 = n8 + this.readInt(n7);
                            n7 += 4;
                            if (labelArray[n12] == null) {
                                labelArray[n12] = new Label();
                            }
                            n2 = this.readInt(n7);
                            n7 += 4;
                            for (n2 = this.readInt(n7 += 4) - n2 + 1; n2 > 0; --n2) {
                                n12 = n8 + this.readInt(n7);
                                n7 += 4;
                                if (labelArray[n12] != null) continue;
                                labelArray[n12] = new Label();
                            }
                            continue block40;
                        }
                        case 14: {
                            n8 = n7 - n16;
                            n7 = n7 + 4 - (n8 & 3);
                            n12 = n8 + this.readInt(n7);
                            n7 += 4;
                            if (labelArray[n12] == null) {
                                labelArray[n12] = new Label();
                            }
                            n2 = this.readInt(n7);
                            n7 += 4;
                            while (n2 > 0) {
                                n12 = n8 + this.readInt(n7 += 4);
                                n7 += 4;
                                if (labelArray[n12] == null) {
                                    labelArray[n12] = new Label();
                                }
                                --n2;
                            }
                            continue block40;
                        }
                        case 1: 
                        case 3: 
                        case 10: {
                            n7 += 2;
                            continue block40;
                        }
                        case 2: 
                        case 5: 
                        case 6: 
                        case 11: 
                        case 12: {
                            n7 += 3;
                            continue block40;
                        }
                        case 7: {
                            n7 += 5;
                            continue block40;
                        }
                    }
                    n7 += 4;
                }
                n2 = this.readUnsignedShort(n7);
                n7 += 2;
                while (n2 > 0) {
                    n12 = this.readUnsignedShort(n7);
                    if (labelArray[n12] == null) {
                        labelArray[n12] = new Label();
                    }
                    if (labelArray[n12 = this.readUnsignedShort(n7 + 2)] == null) {
                        labelArray[n12] = new Label();
                    }
                    if (labelArray[n12 = this.readUnsignedShort(n7 + 4)] == null) {
                        labelArray[n12] = new Label();
                    }
                    n7 += 8;
                    --n2;
                }
                n2 = this.readUnsignedShort(n7);
                n7 += 2;
                while (n2 > 0) {
                    String string4 = this.readUTF8(n7, cArray);
                    if (string4.equals("LocalVariableTable")) {
                        if (!bl) {
                            n8 = n7 + 8;
                            for (n11 = this.readUnsignedShort(n7 + 6); n11 > 0; --n11) {
                                n12 = this.readUnsignedShort(n8);
                                if (labelArray[n12] == null) {
                                    labelArray[n12] = new Label();
                                }
                                if (labelArray[n12 += this.readUnsignedShort(n8 + 2)] == null) {
                                    labelArray[n12] = new Label();
                                }
                                n8 += 10;
                            }
                        }
                    } else if (string4.equals("LineNumberTable")) {
                        if (!bl) {
                            n8 = n7 + 8;
                            for (n11 = this.readUnsignedShort(n7 + 6); n11 > 0; --n11) {
                                n12 = this.readUnsignedShort(n8);
                                if (labelArray[n12] == null) {
                                    labelArray[n12] = new Label();
                                }
                                labelArray[n12].line = this.readUnsignedShort(n8 + 2);
                                n8 += 4;
                            }
                        }
                    } else {
                        for (n11 = 0; n11 < attributeArray.length; ++n11) {
                            if (!attributeArray[n11].type.equals(string4) || (object3 = attributeArray[n11].read(this, n7 + 6, this.readInt(n7 + 2), cArray, n16 - 8, labelArray)) == null) continue;
                            ((Attribute)object3).next = object6;
                            object6 = object3;
                        }
                    }
                    n7 += 6 + this.readInt(n7 + 2);
                    --n2;
                }
                n7 = n16;
                block48: while (n7 < n17) {
                    n8 = n7 - n16;
                    Label label = labelArray[n8];
                    if (label != null) {
                        codeVisitor.visitLabel(label);
                        if (!bl && label.line > 0) {
                            codeVisitor.visitLineNumber(label.line, label);
                        }
                    }
                    int n19 = byArray[n7] & 0xFF;
                    switch (ClassWriter.TYPE[n19]) {
                        case 0: {
                            codeVisitor.visitInsn(n19);
                            ++n7;
                            continue block48;
                        }
                        case 4: {
                            if (n19 > 54) {
                                codeVisitor.visitVarInsn(54 + ((n19 -= 59) >> 2), n19 & 3);
                            } else {
                                codeVisitor.visitVarInsn(21 + ((n19 -= 26) >> 2), n19 & 3);
                            }
                            ++n7;
                            continue block48;
                        }
                        case 8: {
                            codeVisitor.visitJumpInsn(n19, labelArray[n8 + this.readShort(n7 + 1)]);
                            n7 += 3;
                            continue block48;
                        }
                        case 9: {
                            codeVisitor.visitJumpInsn(n19, labelArray[n8 + this.readInt(n7 + 1)]);
                            n7 += 5;
                            continue block48;
                        }
                        case 16: {
                            n19 = byArray[n7 + 1] & 0xFF;
                            if (n19 == 132) {
                                codeVisitor.visitIincInsn(this.readUnsignedShort(n7 + 2), this.readShort(n7 + 4));
                                n7 += 6;
                                continue block48;
                            }
                            codeVisitor.visitVarInsn(n19, this.readUnsignedShort(n7 + 2));
                            n7 += 4;
                            continue block48;
                        }
                        case 13: {
                            n7 = n7 + 4 - (n8 & 3);
                            n12 = n8 + this.readInt(n7);
                            int n20 = this.readInt(n7 += 4);
                            int n21 = this.readInt(n7 += 4);
                            n7 += 4;
                            Label[] labelArray2 = new Label[n21 - n20 + 1];
                            for (n2 = 0; n2 < labelArray2.length; ++n2) {
                                labelArray2[n2] = labelArray[n8 + this.readInt(n7)];
                                n7 += 4;
                            }
                            codeVisitor.visitTableSwitchInsn(n20, n21, labelArray[n12], labelArray2);
                            continue block48;
                        }
                        case 14: {
                            n7 = n7 + 4 - (n8 & 3);
                            n12 = n8 + this.readInt(n7);
                            n2 = this.readInt(n7 += 4);
                            n7 += 4;
                            int[] nArray = new int[n2];
                            Label[] labelArray3 = new Label[n2];
                            for (n2 = 0; n2 < nArray.length; ++n2) {
                                nArray[n2] = this.readInt(n7);
                                labelArray3[n2] = labelArray[n8 + this.readInt(n7 += 4)];
                                n7 += 4;
                            }
                            codeVisitor.visitLookupSwitchInsn(labelArray[n12], nArray, labelArray3);
                            continue block48;
                        }
                        case 3: {
                            codeVisitor.visitVarInsn(n19, byArray[n7 + 1] & 0xFF);
                            n7 += 2;
                            continue block48;
                        }
                        case 1: {
                            codeVisitor.visitIntInsn(n19, byArray[n7 + 1]);
                            n7 += 2;
                            continue block48;
                        }
                        case 2: {
                            codeVisitor.visitIntInsn(n19, this.readShort(n7 + 1));
                            n7 += 3;
                            continue block48;
                        }
                        case 10: {
                            codeVisitor.visitLdcInsn(this.readConst(byArray[n7 + 1] & 0xFF, cArray));
                            n7 += 2;
                            continue block48;
                        }
                        case 11: {
                            codeVisitor.visitLdcInsn(this.readConst(this.readUnsignedShort(n7 + 1), cArray));
                            n7 += 3;
                            continue block48;
                        }
                        case 6: 
                        case 7: {
                            int n22 = this.items[this.readUnsignedShort(n7 + 1)];
                            String string5 = this.readClass(n22, cArray);
                            n22 = this.items[this.readUnsignedShort(n22 + 2)];
                            String string6 = this.readUTF8(n22, cArray);
                            String string7 = this.readUTF8(n22 + 2, cArray);
                            if (n19 < 182) {
                                codeVisitor.visitFieldInsn(n19, string5, string6, string7);
                            } else {
                                codeVisitor.visitMethodInsn(n19, string5, string6, string7);
                            }
                            if (n19 == 185) {
                                n7 += 5;
                                continue block48;
                            }
                            n7 += 3;
                            continue block48;
                        }
                        case 5: {
                            codeVisitor.visitTypeInsn(n19, this.readClass(n7 + 1, cArray));
                            n7 += 3;
                            continue block48;
                        }
                        case 12: {
                            codeVisitor.visitIincInsn(byArray[n7 + 1] & 0xFF, byArray[n7 + 2]);
                            n7 += 3;
                            continue block48;
                        }
                    }
                    codeVisitor.visitMultiANewArrayInsn(this.readClass(n7 + 1, cArray), byArray[n7 + 3] & 0xFF);
                    n7 += 4;
                }
                Label label = labelArray[n17 - n16];
                if (label != null) {
                    codeVisitor.visitLabel(label);
                }
                n2 = this.readUnsignedShort(n7);
                n7 += 2;
                while (n2 > 0) {
                    Label label2 = labelArray[this.readUnsignedShort(n7)];
                    Label label3 = labelArray[this.readUnsignedShort(n7 + 2)];
                    Label label4 = labelArray[this.readUnsignedShort(n7 + 4)];
                    int n23 = this.readUnsignedShort(n7 + 6);
                    if (n23 == 0) {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, null);
                    } else {
                        codeVisitor.visitTryCatchBlock(label2, label3, label4, this.readUTF8(this.items[n23], cArray));
                    }
                    n7 += 8;
                    --n2;
                }
                n2 = this.readUnsignedShort(n7);
                n7 += 2;
                if (!bl) {
                    while (n2 > 0) {
                        String string8 = this.readUTF8(n7, cArray);
                        if (string8.equals("LocalVariableTable")) {
                            n8 = n7 + 8;
                            for (n11 = this.readUnsignedShort(n7 + 6); n11 > 0; --n11) {
                                n12 = this.readUnsignedShort(n8);
                                Label label5 = labelArray[n12];
                                Label label6 = labelArray[n12 += this.readUnsignedShort(n8 + 2)];
                                codeVisitor.visitLocalVariable(this.readUTF8(n8 + 4, cArray), this.readUTF8(n8 + 6, cArray), label5, label6, this.readUnsignedShort(n8 + 8));
                                n8 += 10;
                            }
                        }
                        n7 += 6 + this.readInt(n7 + 2);
                        --n2;
                    }
                }
                while (object6 != null) {
                    object3 = ((Attribute)object6).next;
                    ((Attribute)object6).next = null;
                    codeVisitor.visitAttribute((Attribute)object6);
                    object6 = object3;
                }
                codeVisitor.visitMaxs(n13, n14);
            }
            --n3;
        }
        object4 = null;
        object3 = object5;
        while (object3 != null) {
            object2 = ((Attribute)object3).next;
            ((Attribute)object3).next = object4;
            object4 = object3;
            object3 = object2;
        }
        while (object4 != null) {
            object3 = ((Attribute)object4).next;
            ((Attribute)object4).next = null;
            classVisitor.visitAttribute((Attribute)object4);
            object4 = object3;
        }
        classVisitor.visitEnd();
    }

    public int getItem(int n2) {
        return this.items[n2];
    }

    public int readByte(int n2) {
        return this.b[n2] & 0xFF;
    }

    public int readUnsignedShort(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    public short readShort(int n2) {
        byte[] byArray = this.b;
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    public int readInt(int n2) {
        byte[] byArray = this.b;
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    public long readLong(int n2) {
        long l2 = this.readInt(n2);
        long l3 = (long)this.readInt(n2 + 4) & 0xFFFFFFFFL;
        return l2 << 32 | l3;
    }

    public String readUTF8(int n2, char[] cArray) {
        int n3 = this.readUnsignedShort(n2);
        String string = this.strings[n3];
        if (string != null) {
            return string;
        }
        n2 = this.items[n3];
        int n4 = this.readUnsignedShort(n2);
        int n5 = (n2 += 2) + n4;
        byte[] byArray = this.b;
        int n6 = 0;
        block4: while (n2 < n5) {
            byte by;
            int n7 = byArray[n2++] & 0xFF;
            switch (n7 >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    cArray[n6++] = (char)n7;
                    continue block4;
                }
                case 12: 
                case 13: {
                    by = byArray[n2++];
                    cArray[n6++] = (char)((n7 & 0x1F) << 6 | by & 0x3F);
                    continue block4;
                }
            }
            by = byArray[n2++];
            byte by2 = byArray[n2++];
            cArray[n6++] = (char)((n7 & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
        }
        this.strings[n3] = string = new String(cArray, 0, n6);
        return string;
    }

    public String readClass(int n2, char[] cArray) {
        return this.readUTF8(this.items[this.readUnsignedShort(n2)], cArray);
    }

    public Object readConst(int n2, char[] cArray) {
        int n3 = this.items[n2];
        switch (this.b[n3 - 1]) {
            case 3: {
                return new Integer(this.readInt(n3));
            }
            case 4: {
                return new Float(Float.intBitsToFloat(this.readInt(n3)));
            }
            case 5: {
                return new Long(this.readLong(n3));
            }
            case 6: {
                return new Double(Double.longBitsToDouble(this.readLong(n3)));
            }
            case 7: {
                String string = this.readUTF8(n3, cArray);
                return Type.getType(string.charAt(0) == '[' ? string : "L" + string + ";");
            }
        }
        return this.readUTF8(n3, cArray);
    }

    protected Attribute readAttribute(Attribute[] attributeArray, String string, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        for (int i2 = 0; i2 < attributeArray.length; ++i2) {
            if (!attributeArray[i2].type.equals(string)) continue;
            return attributeArray[i2].read(this, n2, n3, cArray, n4, labelArray);
        }
        return new Attribute(string);
    }
}

