/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.CodeWriter;
import org.objectweb.asm.Item;
import org.objectweb.asm.Type;

public class ClassWriter
implements ClassVisitor {
    static final int CLASS = 7;
    static final int FIELD = 9;
    static final int METH = 10;
    static final int IMETH = 11;
    static final int STR = 8;
    static final int INT = 3;
    static final int FLOAT = 4;
    static final int LONG = 5;
    static final int DOUBLE = 6;
    static final int NAME_TYPE = 12;
    static final int UTF8 = 1;
    private int version;
    private short index = 1;
    private ByteVector pool = new ByteVector();
    private Item[] items = new Item[64];
    private int threshold = (int)(0.75 * (double)this.items.length);
    private int access;
    private int name;
    private int superName;
    private int interfaceCount;
    private int[] interfaces;
    private int sourceFile;
    private int fieldCount;
    private ByteVector fields;
    private boolean computeMaxs;
    boolean checkAttributes;
    CodeWriter firstMethod;
    CodeWriter lastMethod;
    private int innerClassesCount;
    private ByteVector innerClasses;
    private Attribute attrs;
    Item key = new Item();
    Item key2 = new Item();
    Item key3 = new Item();
    static final int NOARG_INSN = 0;
    static final int SBYTE_INSN = 1;
    static final int SHORT_INSN = 2;
    static final int VAR_INSN = 3;
    static final int IMPLVAR_INSN = 4;
    static final int TYPE_INSN = 5;
    static final int FIELDORMETH_INSN = 6;
    static final int ITFMETH_INSN = 7;
    static final int LABEL_INSN = 8;
    static final int LABELW_INSN = 9;
    static final int LDC_INSN = 10;
    static final int LDCW_INSN = 11;
    static final int IINC_INSN = 12;
    static final int TABL_INSN = 13;
    static final int LOOK_INSN = 14;
    static final int MANA_INSN = 15;
    static final int WIDE_INSN = 16;
    static byte[] TYPE;

    public ClassWriter(boolean bl) {
        this(bl, false);
    }

    public ClassWriter(boolean bl, boolean bl2) {
        this.computeMaxs = bl;
        this.checkAttributes = !bl2;
    }

    public void visit(int n2, int n3, String string, String string2, String[] stringArray, String string3) {
        this.version = n2;
        this.access = n3;
        this.name = this.newClass(string);
        int n4 = this.superName = string2 == null ? 0 : this.newClass(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.interfaceCount = stringArray.length;
            this.interfaces = new int[this.interfaceCount];
            for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
                this.interfaces[i2] = this.newClass(stringArray[i2]);
            }
        }
        if (string3 != null) {
            this.newUTF8("SourceFile");
            this.sourceFile = this.newUTF8(string3);
        }
        if ((n3 & 0x20000) != 0) {
            this.newUTF8("Deprecated");
        }
        if ((n3 & 0x1000) != 0) {
            this.newUTF8("Synthetic");
        }
    }

    public void visitInnerClass(String string, String string2, String string3, int n2) {
        if (this.innerClasses == null) {
            this.newUTF8("InnerClasses");
            this.innerClasses = new ByteVector();
        }
        ++this.innerClassesCount;
        this.innerClasses.putShort(string == null ? 0 : this.newClass(string));
        this.innerClasses.putShort(string2 == null ? 0 : this.newClass(string2));
        this.innerClasses.putShort(string3 == null ? 0 : this.newUTF8(string3));
        this.innerClasses.putShort(n2);
    }

    public void visitField(int n2, String string, String string2, Object object, Attribute attribute) {
        ++this.fieldCount;
        if (this.fields == null) {
            this.fields = new ByteVector();
        }
        this.fields.putShort(n2).putShort(this.newUTF8(string)).putShort(this.newUTF8(string2));
        int n3 = 0;
        if (object != null) {
            ++n3;
        }
        if ((n2 & 0x1000) != 0) {
            ++n3;
        }
        if ((n2 & 0x20000) != 0) {
            ++n3;
        }
        if (attribute != null) {
            n3 += attribute.getCount();
        }
        this.fields.putShort(n3);
        if (object != null) {
            this.fields.putShort(this.newUTF8("ConstantValue"));
            this.fields.putInt(2).putShort(this.newConstItem((Object)object).index);
        }
        if ((n2 & 0x1000) != 0) {
            this.fields.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if ((n2 & 0x20000) != 0) {
            this.fields.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if (attribute != null) {
            attribute.put(this, null, 0, -1, -1, this.fields);
        }
    }

    public CodeVisitor visitMethod(int n2, String string, String string2, String[] stringArray, Attribute attribute) {
        CodeWriter codeWriter = new CodeWriter(this, this.computeMaxs);
        codeWriter.init(n2, string, string2, stringArray, attribute);
        return codeWriter;
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.attrs;
        this.attrs = attribute;
    }

    public void visitEnd() {
    }

    public byte[] toByteArray() {
        int n2 = 24 + 2 * this.interfaceCount;
        if (this.fields != null) {
            n2 += this.fields.length;
        }
        int n3 = 0;
        CodeWriter codeWriter = this.firstMethod;
        while (codeWriter != null) {
            ++n3;
            n2 += codeWriter.getSize();
            codeWriter = codeWriter.next;
        }
        int n4 = 0;
        if (this.sourceFile != 0) {
            ++n4;
            n2 += 8;
        }
        if ((this.access & 0x20000) != 0) {
            ++n4;
            n2 += 6;
        }
        if ((this.access & 0x1000) != 0) {
            ++n4;
            n2 += 6;
        }
        if (this.innerClasses != null) {
            ++n4;
            n2 += 8 + this.innerClasses.length;
        }
        if (this.attrs != null) {
            n4 += this.attrs.getCount();
            n2 += this.attrs.getSize(this, null, 0, -1, -1);
        }
        ByteVector byteVector = new ByteVector(n2 += this.pool.length);
        byteVector.putInt(-889275714).putInt(this.version);
        byteVector.putShort(this.index).putByteArray(this.pool.data, 0, this.pool.length);
        byteVector.putShort(this.access).putShort(this.name).putShort(this.superName);
        byteVector.putShort(this.interfaceCount);
        for (int i2 = 0; i2 < this.interfaceCount; ++i2) {
            byteVector.putShort(this.interfaces[i2]);
        }
        byteVector.putShort(this.fieldCount);
        if (this.fields != null) {
            byteVector.putByteArray(this.fields.data, 0, this.fields.length);
        }
        byteVector.putShort(n3);
        codeWriter = this.firstMethod;
        while (codeWriter != null) {
            codeWriter.put(byteVector);
            codeWriter = codeWriter.next;
        }
        byteVector.putShort(n4);
        if (this.sourceFile != 0) {
            byteVector.putShort(this.newUTF8("SourceFile")).putInt(2).putShort(this.sourceFile);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.newUTF8("Deprecated")).putInt(0);
        }
        if ((this.access & 0x1000) != 0) {
            byteVector.putShort(this.newUTF8("Synthetic")).putInt(0);
        }
        if (this.innerClasses != null) {
            byteVector.putShort(this.newUTF8("InnerClasses"));
            byteVector.putInt(this.innerClasses.length + 2).putShort(this.innerClassesCount);
            byteVector.putByteArray(this.innerClasses.data, 0, this.innerClasses.length);
        }
        if (this.attrs != null) {
            this.attrs.put(this, null, 0, -1, -1, byteVector);
        }
        return byteVector.data;
    }

    Item newConstItem(Object object) {
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            return this.newInteger(n2);
        }
        if (object instanceof Byte) {
            int n3 = ((Byte)object).intValue();
            return this.newInteger(n3);
        }
        if (object instanceof Character) {
            char c2 = ((Character)object).charValue();
            return this.newInteger(c2);
        }
        if (object instanceof Short) {
            int n4 = ((Short)object).intValue();
            return this.newInteger(n4);
        }
        if (object instanceof Boolean) {
            int n5 = (Boolean)object != false ? 1 : 0;
            return this.newInteger(n5);
        }
        if (object instanceof Float) {
            float f2 = ((Float)object).floatValue();
            return this.newFloat(f2);
        }
        if (object instanceof Long) {
            long l2 = (Long)object;
            return this.newLong(l2);
        }
        if (object instanceof Double) {
            double d2 = (Double)object;
            return this.newDouble(d2);
        }
        if (object instanceof String) {
            return this.newString((String)object);
        }
        if (object instanceof Type) {
            Type type = (Type)object;
            return this.newClassItem(type.getSort() == 10 ? type.getInternalName() : type.getDescriptor());
        }
        throw new IllegalArgumentException("value " + object);
    }

    public int newConst(Object object) {
        return this.newConstItem((Object)object).index;
    }

    public int newConstInt(int n2) {
        return this.newInteger((int)n2).index;
    }

    public int newConstLong(long l2) {
        return this.newLong((long)l2).index;
    }

    public int newConstFloat(float f2) {
        return this.newFloat((float)f2).index;
    }

    public int newConstDouble(double d2) {
        return this.newDouble((double)d2).index;
    }

    public int newUTF8(String string) {
        this.key.set(1, string, null, null);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(1).putUTF8(string);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item.index;
    }

    public int newClass(String string) {
        return this.newClassItem((String)string).index;
    }

    private Item newClassItem(String string) {
        this.key2.set(7, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(7, this.newUTF8(string));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newField(String string, String string2, String string3) {
        this.key3.set(9, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(9, this.newClass(string), this.newNameType(string2, string3));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item.index;
    }

    Item newMethodItem(String string, String string2, String string3, boolean bl) {
        this.key3.set(bl ? 11 : 10, string, string2, string3);
        Item item = this.get(this.key3);
        if (item == null) {
            this.put122(bl ? 11 : 10, this.newClass(string), this.newNameType(string2, string3));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key3);
            this.put(item);
        }
        return item;
    }

    public int newMethod(String string, String string2, String string3, boolean bl) {
        return this.newMethodItem((String)string, (String)string2, (String)string3, (boolean)bl).index;
    }

    private Item newInteger(int n2) {
        this.key.set(n2);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(3).putInt(n2);
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newFloat(float f2) {
        this.key.set(f2);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(4).putInt(Float.floatToIntBits(f2));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key);
            this.put(item);
        }
        return item;
    }

    private Item newLong(long l2) {
        this.key.set(l2);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(5).putLong(l2);
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newDouble(double d2) {
        this.key.set(d2);
        Item item = this.get(this.key);
        if (item == null) {
            this.pool.putByte(6).putLong(Double.doubleToLongBits(d2));
            item = new Item(this.index, this.key);
            this.put(item);
            this.index = (short)(this.index + 2);
        }
        return item;
    }

    private Item newString(String string) {
        this.key2.set(8, string, null, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.pool.put12(8, this.newUTF8(string));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item;
    }

    public int newNameType(String string, String string2) {
        this.key2.set(12, string, string2, null);
        Item item = this.get(this.key2);
        if (item == null) {
            this.put122(12, this.newUTF8(string), this.newUTF8(string2));
            short s = this.index;
            this.index = (short)(s + 1);
            item = new Item(s, this.key2);
            this.put(item);
        }
        return item.index;
    }

    private Item get(Item item) {
        int n2 = item.hashCode;
        Item item2 = this.items[n2 % this.items.length];
        while (item2 != null) {
            if (item2.hashCode == n2 && item.isEqualTo(item2)) {
                return item2;
            }
            item2 = item2.next;
        }
        return null;
    }

    private void put(Item item) {
        if (this.index > this.threshold) {
            Item[] itemArray = new Item[this.items.length * 2 + 1];
            for (int i2 = this.items.length - 1; i2 >= 0; --i2) {
                Item item2 = this.items[i2];
                while (item2 != null) {
                    int n2 = item2.hashCode % itemArray.length;
                    Item item3 = item2.next;
                    item2.next = itemArray[n2];
                    itemArray[n2] = item2;
                    item2 = item3;
                }
            }
            this.items = itemArray;
            this.threshold = (int)((double)this.items.length * 0.75);
        }
        int n3 = item.hashCode % this.items.length;
        item.next = this.items[n3];
        this.items[n3] = item;
    }

    private void put122(int n2, int n3, int n4) {
        this.pool.put12(n2, n3).putShort(n4);
    }

    static {
        byte[] byArray = new byte[220];
        String string = "AAAAAAAAAAAAAAAABCKLLDDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAADDDDDEEEEEEEEEEEEEEEEEEEEAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAMAAAAAAAAAAAAAAAAAAAAIIIIIIIIIIIIIIIIDNOAAAAAAGGGGGGGHAFBFAAFFAAQPIIJJIIIIIIIIIIIIIIIIII";
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            byArray[i2] = (byte)(string.charAt(i2) - 65);
        }
        TYPE = byArray;
    }
}

