/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.CodeVisitor;
import org.objectweb.asm.Edge;
import org.objectweb.asm.Item;
import org.objectweb.asm.Label;

public class CodeWriter
implements CodeVisitor {
    static final boolean CHECK = false;
    CodeWriter next;
    private ClassWriter cw;
    private int name;
    private int desc;
    private int access;
    private int maxStack;
    private int maxLocals;
    private ByteVector code = new ByteVector();
    private int catchCount;
    private ByteVector catchTable;
    private int exceptionCount;
    private int[] exceptions;
    private Attribute attrs;
    private int localVarCount;
    private ByteVector localVar;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private Attribute cattrs;
    private boolean resize;
    private final boolean computeMaxs;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;
    private Edge head;
    private Edge tail;
    private static Edge pool;

    protected CodeWriter(ClassWriter classWriter, boolean bl) {
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.computeMaxs = bl;
        if (bl) {
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    protected void init(int n2, String string, String string2, String[] stringArray, Attribute attribute) {
        int n3;
        this.access = n2;
        this.name = this.cw.newUTF8(string);
        this.desc = this.cw.newUTF8(string2);
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (n3 = 0; n3 < this.exceptionCount; ++n3) {
                this.exceptions[n3] = this.cw.newClass(stringArray[n3]);
            }
        }
        this.attrs = attribute;
        if (this.computeMaxs) {
            n3 = CodeWriter.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n2 & 8) != 0) {
                --n3;
            }
            if (n3 > this.maxLocals) {
                this.maxLocals = n3;
            }
        }
    }

    public void visitInsn(int n2) {
        if (this.computeMaxs) {
            int n3 = this.stackSize + SIZE[n2];
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
            if ((n2 >= 172 && n2 <= 177 || n2 == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.putByte(n2);
    }

    public void visitIntInsn(int n2, int n3) {
        if (this.computeMaxs && n2 != 188) {
            int n4 = this.stackSize + 1;
            if (n4 > this.maxStackSize) {
                this.maxStackSize = n4;
            }
            this.stackSize = n4;
        }
        if (n2 == 17) {
            this.code.put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
    }

    public void visitVarInsn(int n2, int n3) {
        int n4;
        if (this.computeMaxs) {
            if (n2 == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                n4 = this.stackSize + SIZE[n2];
                if (n4 > this.maxStackSize) {
                    this.maxStackSize = n4;
                }
                this.stackSize = n4;
            }
            if ((n4 = n2 == 22 || n2 == 24 || n2 == 55 || n2 == 57 ? n3 + 2 : n3 + 1) > this.maxLocals) {
                this.maxLocals = n4;
            }
        }
        if (n3 < 4 && n2 != 169) {
            n4 = n2 < 54 ? 26 + (n2 - 21 << 2) + n3 : 59 + (n2 - 54 << 2) + n3;
            this.code.putByte(n4);
        } else if (n3 >= 256) {
            this.code.putByte(196).put12(n2, n3);
        } else {
            this.code.put11(n2, n3);
        }
    }

    public void visitTypeInsn(int n2, String string) {
        if (this.computeMaxs && n2 == 187) {
            int n3 = this.stackSize + 1;
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        this.code.put12(n2, this.cw.newClass(string));
    }

    public void visitFieldInsn(int n2, String string, String string2, String string3) {
        if (this.computeMaxs) {
            int n3;
            char c2 = string3.charAt(0);
            switch (n2) {
                case 178: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    n3 = this.stackSize + (c2 == 'D' || c2 == 'J' ? -3 : -2);
                }
            }
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        this.code.put12(n2, this.cw.newField(string, string2, string3));
    }

    public void visitMethodInsn(int n2, String string, String string2, String string3) {
        boolean bl = n2 == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n3 = item.intVal;
        if (this.computeMaxs) {
            int n4;
            if (n3 == 0) {
                item.intVal = n3 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            if ((n4 = n2 == 184 ? this.stackSize - (n3 >> 2) + (n3 & 3) + 1 : this.stackSize - (n3 >> 2) + (n3 & 3)) > this.maxStackSize) {
                this.maxStackSize = n4;
            }
            this.stackSize = n4;
        }
        if (bl) {
            if (!this.computeMaxs && n3 == 0) {
                item.intVal = n3 = CodeWriter.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n3 >> 2, 0);
        } else {
            this.code.put12(n2, item.index);
        }
    }

    public void visitJumpInsn(int n2, Label label) {
        if (this.computeMaxs) {
            if (n2 == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (n2 == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[n2];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (n2 == 167) {
                this.code.putByte(200);
            } else if (n2 == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(n2 <= 166 ? (n2 + 1 ^ 1) - 1 : n2 ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(n2);
            label.put(this, this.code, this.code.length - 1, false);
        }
    }

    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this, this.code.length, this.code.data);
    }

    public void visitLdcInsn(Object object) {
        int n2;
        Item item = this.cw.newConstItem(object);
        if (this.computeMaxs) {
            n2 = item.type == 5 || item.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        n2 = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n2);
        } else if (n2 >= 256) {
            this.code.put12(19, n2);
        } else {
            this.code.put11(18, n2);
        }
    }

    public void visitIincInsn(int n2, int n3) {
        int n4;
        if (this.computeMaxs && (n4 = n2 + 1) > this.maxLocals) {
            this.maxLocals = n4;
        }
        if (n2 > 255 || n3 > 127 || n3 < -128) {
            this.code.putByte(196).put12(132, n2).putShort(n3);
        } else {
            this.code.putByte(132).put11(n2, n3);
        }
    }

    public void visitTableSwitchInsn(int n2, int n3, Label label, Label[] labelArray) {
        int n4;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n4 = 0; n4 < labelArray.length; ++n4) {
                    this.addSuccessor(this.stackSize, labelArray[n4]);
                }
                this.currentBlock = null;
            }
        }
        n4 = this.code.length;
        this.code.putByte(170);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        label.put(this, this.code, n4, true);
        this.code.putInt(n2).putInt(n3);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            labelArray[i2].put(this, this.code, n4, true);
        }
    }

    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n2;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n2 = 0; n2 < labelArray.length; ++n2) {
                    this.addSuccessor(this.stackSize, labelArray[n2]);
                }
                this.currentBlock = null;
            }
        }
        n2 = this.code.length;
        this.code.putByte(171);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        label.put(this, this.code, n2, true);
        this.code.putInt(labelArray.length);
        for (int i2 = 0; i2 < labelArray.length; ++i2) {
            this.code.putInt(nArray[i2]);
            labelArray[i2].put(this, this.code, n2, true);
        }
    }

    public void visitMultiANewArrayInsn(String string, int n2) {
        if (this.computeMaxs) {
            this.stackSize += 1 - n2;
        }
        this.code.put12(197, this.cw.newClass(string)).putByte(n2);
    }

    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (this.computeMaxs && !label3.pushed) {
            label3.beginStackSize = 1;
            label3.pushed = true;
            label3.next = this.blockStack;
            this.blockStack = label3;
        }
        ++this.catchCount;
        if (this.catchTable == null) {
            this.catchTable = new ByteVector();
        }
        this.catchTable.putShort(label.position);
        this.catchTable.putShort(label2.position);
        this.catchTable.putShort(label3.position);
        this.catchTable.putShort(string != null ? this.cw.newClass(string) : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitMaxs(int n2, int n3) {
        if (this.computeMaxs) {
            Object object;
            int n4 = 0;
            Object object2 = this.blockStack;
            while (object2 != null) {
                object = object2;
                object2 = ((Label)object2).next;
                int n5 = ((Label)object).beginStackSize;
                int n6 = n5 + ((Label)object).maxStackSize;
                if (n6 > n4) {
                    n4 = n6;
                }
                Edge edge = ((Label)object).successors;
                while (edge != null) {
                    object = edge.successor;
                    if (!((Label)object).pushed) {
                        ((Label)object).beginStackSize = n5 + edge.stackSize;
                        ((Label)object).pushed = true;
                        ((Label)object).next = object2;
                        object2 = object;
                    }
                    edge = edge.next;
                }
            }
            this.maxStack = n4;
            object = SIZE;
            synchronized (SIZE) {
                if (this.tail != null) {
                    this.tail.poolNext = pool;
                    pool = this.head;
                }
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        } else {
            this.maxStack = n2;
            this.maxLocals = n3;
        }
    }

    public void visitLocalVariable(String string, String string2, Label label, Label label2, int n2) {
        if (this.localVar == null) {
            this.cw.newUTF8("LocalVariableTable");
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.putShort(label.position);
        this.localVar.putShort(label2.position - label.position);
        this.localVar.putShort(this.cw.newUTF8(string));
        this.localVar.putShort(this.cw.newUTF8(string2));
        this.localVar.putShort(n2);
    }

    public void visitLineNumber(int n2, Label label) {
        if (this.lineNumber == null) {
            this.cw.newUTF8("LineNumberTable");
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.putShort(label.position);
        this.lineNumber.putShort(n2);
    }

    public void visitAttribute(Attribute attribute) {
        attribute.next = this.cattrs;
        this.cattrs = attribute;
    }

    private static int getArgumentsAndReturnSizes(String string) {
        int n2 = 1;
        int n3 = 1;
        while (true) {
            char c2;
            if ((c2 = string.charAt(n3++)) == ')') {
                c2 = string.charAt(n3);
                return n2 << 2 | (c2 == 'V' ? 0 : (c2 == 'D' || c2 == 'J' ? 2 : 1));
            }
            if (c2 == 'L') {
                while (string.charAt(n3++) != ';') {
                }
                ++n2;
                continue;
            }
            if (c2 == '[') {
                while ((c2 = string.charAt(n3)) == '[') {
                    ++n3;
                }
                if (c2 != 'D' && c2 != 'J') continue;
                --n2;
                continue;
            }
            if (c2 == 'D' || c2 == 'J') {
                n2 += 2;
                continue;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSuccessor(int n2, Label label) {
        int[] nArray = SIZE;
        synchronized (SIZE) {
            Edge edge;
            if (pool == null) {
                edge = new Edge();
            } else {
                edge = pool;
                pool = CodeWriter.pool.poolNext;
            }
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (this.tail == null) {
                this.tail = edge;
            }
            edge.poolNext = this.head;
            this.head = edge;
            edge.stackSize = n2;
            edge.successor = label;
            edge.next = this.currentBlock.successors;
            this.currentBlock.successors = edge;
            return;
        }
    }

    final int getSize() {
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n2 += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n2 += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n2 += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x1000) != 0) {
            this.cw.newUTF8("Synthetic");
            n2 += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            n2 += 6;
        }
        if (this.attrs != null) {
            n2 += this.attrs.getSize(this.cw, null, 0, -1, -1);
        }
        return n2;
    }

    final void put(ByteVector byteVector) {
        int n2;
        byteVector.putShort(this.access).putShort(this.name).putShort(this.desc);
        int n3 = 0;
        if (this.code.length > 0) {
            ++n3;
        }
        if (this.exceptionCount > 0) {
            ++n3;
        }
        if ((this.access & 0x1000) != 0) {
            ++n3;
        }
        if ((this.access & 0x20000) != 0) {
            ++n3;
        }
        if (this.attrs != null) {
            n3 += this.attrs.getCount();
        }
        byteVector.putShort(n3);
        if (this.code.length > 0) {
            n2 = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n2 += 8 + this.localVar.length;
            }
            if (this.lineNumber != null) {
                n2 += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n2 += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n2);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(this.catchCount);
            if (this.catchCount > 0) {
                byteVector.putByteArray(this.catchTable.data, 0, this.catchTable.length);
            }
            n3 = 0;
            if (this.localVar != null) {
                ++n3;
            }
            if (this.lineNumber != null) {
                ++n3;
            }
            if (this.cattrs != null) {
                n3 += this.cattrs.getCount();
            }
            byteVector.putShort(n3);
            if (this.localVar != null) {
                byteVector.putShort(this.cw.newUTF8("LocalVariableTable"));
                byteVector.putInt(this.localVar.length + 2).putShort(this.localVarCount);
                byteVector.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.lineNumber != null) {
                byteVector.putShort(this.cw.newUTF8("LineNumberTable"));
                byteVector.putInt(this.lineNumber.length + 2).putShort(this.lineNumberCount);
                byteVector.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, this.code.data, this.code.length, this.maxLocals, this.maxStack, byteVector);
            }
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                byteVector.putShort(this.exceptions[n2]);
            }
        }
        if ((this.access & 0x1000) != 0) {
            byteVector.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, null, 0, -1, -1, byteVector);
        }
    }

    protected int[] resizeInstructions(int[] nArray, int[] nArray2, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        byte[] byArray = this.code.data;
        int[] nArray3 = new int[n2];
        int[] nArray4 = new int[n2];
        System.arraycopy(nArray, 0, nArray3, 0, n2);
        System.arraycopy(nArray2, 0, nArray4, 0, n2);
        boolean[] blArray = new boolean[this.code.length];
        int n8 = 3;
        do {
            if (n8 == 3) {
                n8 = 2;
            }
            n7 = 0;
            while (n7 < byArray.length) {
                int n9 = byArray[n7] & 0xFF;
                n6 = 0;
                switch (ClassWriter.TYPE[n9]) {
                    case 0: 
                    case 4: {
                        ++n7;
                        break;
                    }
                    case 8: {
                        if (n9 > 201) {
                            n9 = n9 < 218 ? n9 - 49 : n9 - 20;
                            n5 = n7 + CodeWriter.readUnsignedShort(byArray, n7 + 1);
                        } else {
                            n5 = n7 + CodeWriter.readShort(byArray, n7 + 1);
                        }
                        n4 = CodeWriter.getNewOffset(nArray3, nArray4, n7, n5);
                        if (!(n4 >= Short.MIN_VALUE && n4 <= Short.MAX_VALUE || blArray[n7])) {
                            n6 = n9 == 167 || n9 == 168 ? 2 : 5;
                            blArray[n7] = true;
                        }
                        n7 += 3;
                        break;
                    }
                    case 9: {
                        n7 += 5;
                        break;
                    }
                    case 13: {
                        if (n8 == 1) {
                            n4 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n7);
                            n6 = -(n4 & 3);
                        } else if (!blArray[n7]) {
                            n6 = n7 & 3;
                            blArray[n7] = true;
                        }
                        n7 = n7 + 4 - (n7 & 3);
                        n7 += 4 * (CodeWriter.readInt(byArray, n7 + 8) - CodeWriter.readInt(byArray, n7 + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (n8 == 1) {
                            n4 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n7);
                            n6 = -(n4 & 3);
                        } else if (!blArray[n7]) {
                            n6 = n7 & 3;
                            blArray[n7] = true;
                        }
                        n7 = n7 + 4 - (n7 & 3);
                        n7 += 8 * CodeWriter.readInt(byArray, n7 + 4) + 8;
                        break;
                    }
                    case 16: {
                        n9 = byArray[n7 + 1] & 0xFF;
                        if (n9 == 132) {
                            n7 += 6;
                            break;
                        }
                        n7 += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        n7 += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        n7 += 3;
                        break;
                    }
                    case 7: {
                        n7 += 5;
                        break;
                    }
                    default: {
                        n7 += 4;
                    }
                }
                if (n6 == 0) continue;
                int[] nArray5 = new int[nArray3.length + 1];
                int[] nArray6 = new int[nArray4.length + 1];
                System.arraycopy(nArray3, 0, nArray5, 0, nArray3.length);
                System.arraycopy(nArray4, 0, nArray6, 0, nArray4.length);
                nArray5[nArray3.length] = n7;
                nArray6[nArray4.length] = n6;
                nArray3 = nArray5;
                nArray4 = nArray6;
                if (n6 <= 0) continue;
                n8 = 3;
            }
            if (n8 >= 3) continue;
            --n8;
        } while (n8 != 0);
        ByteVector byteVector = new ByteVector(this.code.length);
        n7 = 0;
        block24: while (n7 < this.code.length) {
            for (n3 = nArray3.length - 1; n3 >= 0; --n3) {
                if (nArray3[n3] != n7 || n3 >= n2) continue;
                if (nArray2[n3] > 0) {
                    byteVector.putByteArray(null, 0, nArray2[n3]);
                } else {
                    byteVector.length += nArray2[n3];
                }
                nArray[n3] = byteVector.length;
            }
            n6 = byArray[n7] & 0xFF;
            switch (ClassWriter.TYPE[n6]) {
                case 0: 
                case 4: {
                    byteVector.putByte(n6);
                    ++n7;
                    continue block24;
                }
                case 8: {
                    if (n6 > 201) {
                        n6 = n6 < 218 ? n6 - 49 : n6 - 20;
                        n5 = n7 + CodeWriter.readUnsignedShort(byArray, n7 + 1);
                    } else {
                        n5 = n7 + CodeWriter.readShort(byArray, n7 + 1);
                    }
                    n4 = CodeWriter.getNewOffset(nArray3, nArray4, n7, n5);
                    if (blArray[n7]) {
                        if (n6 == 167) {
                            byteVector.putByte(200);
                        } else if (n6 == 168) {
                            byteVector.putByte(201);
                        } else {
                            byteVector.putByte(n6 <= 166 ? (n6 + 1 ^ 1) - 1 : n6 ^ 1);
                            byteVector.putShort(8);
                            byteVector.putByte(200);
                            n4 -= 3;
                        }
                        byteVector.putInt(n4);
                    } else {
                        byteVector.putByte(n6);
                        byteVector.putShort(n4);
                    }
                    n7 += 3;
                    continue block24;
                }
                case 9: {
                    n5 = n7 + CodeWriter.readInt(byArray, n7 + 1);
                    n4 = CodeWriter.getNewOffset(nArray3, nArray4, n7, n5);
                    byteVector.putByte(n6);
                    byteVector.putInt(n4);
                    n7 += 5;
                    continue block24;
                }
                case 13: {
                    int n10 = n7;
                    n7 = n7 + 4 - (n10 & 3);
                    byteVector.putByte(170);
                    while (byteVector.length % 4 != 0) {
                        byteVector.putByte(0);
                    }
                    n5 = n10 + CodeWriter.readInt(byArray, n7);
                    n4 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n5);
                    byteVector.putInt(n4);
                    int n11 = CodeWriter.readInt(byArray, n7 += 4);
                    byteVector.putInt(n11);
                    byteVector.putInt(CodeWriter.readInt(byArray, (n7 += 4) - 4));
                    for (n11 = CodeWriter.readInt(byArray, n7 += 4) - n11 + 1; n11 > 0; --n11) {
                        n5 = n10 + CodeWriter.readInt(byArray, n7);
                        n7 += 4;
                        n4 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n5);
                        byteVector.putInt(n4);
                    }
                    continue block24;
                }
                case 14: {
                    int n11;
                    int n10 = n7;
                    n7 = n7 + 4 - (n10 & 3);
                    byteVector.putByte(171);
                    while (byteVector.length % 4 != 0) {
                        byteVector.putByte(0);
                    }
                    n5 = n10 + CodeWriter.readInt(byArray, n7);
                    n4 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n5);
                    byteVector.putInt(n4);
                    n7 += 4;
                    byteVector.putInt(n11);
                    for (n11 = CodeWriter.readInt(byArray, n7 += 4); n11 > 0; --n11) {
                        byteVector.putInt(CodeWriter.readInt(byArray, n7));
                        n5 = n10 + CodeWriter.readInt(byArray, n7 += 4);
                        n7 += 4;
                        n4 = CodeWriter.getNewOffset(nArray3, nArray4, n10, n5);
                        byteVector.putInt(n4);
                    }
                    continue block24;
                }
                case 16: {
                    n6 = byArray[n7 + 1] & 0xFF;
                    if (n6 == 132) {
                        byteVector.putByteArray(byArray, n7, 6);
                        n7 += 6;
                        continue block24;
                    }
                    byteVector.putByteArray(byArray, n7, 4);
                    n7 += 4;
                    continue block24;
                }
                case 1: 
                case 3: 
                case 10: {
                    byteVector.putByteArray(byArray, n7, 2);
                    n7 += 2;
                    continue block24;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    byteVector.putByteArray(byArray, n7, 3);
                    n7 += 3;
                    continue block24;
                }
                case 7: {
                    byteVector.putByteArray(byArray, n7, 5);
                    n7 += 5;
                    continue block24;
                }
            }
            byteVector.putByteArray(byArray, n7, 4);
            n7 += 4;
        }
        if (this.catchTable != null) {
            byArray = this.catchTable.data;
            for (n7 = 0; n7 < this.catchTable.length; n7 += 8) {
                CodeWriter.writeShort(byArray, n7, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n7)));
                CodeWriter.writeShort(byArray, n7 + 2, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n7 + 2)));
                CodeWriter.writeShort(byArray, n7 + 4, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n7 + 4)));
            }
        }
        if (this.localVar != null) {
            byArray = this.localVar.data;
            for (n7 = 0; n7 < this.localVar.length; n7 += 10) {
                n5 = CodeWriter.readUnsignedShort(byArray, n7);
                n4 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n5);
                CodeWriter.writeShort(byArray, n7, n4);
                n4 = CodeWriter.getNewOffset(nArray3, nArray4, 0, n5 += CodeWriter.readUnsignedShort(byArray, n7 + 2)) - n4;
                CodeWriter.writeShort(byArray, n7 + 2, n4);
            }
        }
        if (this.lineNumber != null) {
            byArray = this.lineNumber.data;
            for (n7 = 0; n7 < this.lineNumber.length; n7 += 4) {
                CodeWriter.writeShort(byArray, n7, CodeWriter.getNewOffset(nArray3, nArray4, 0, CodeWriter.readUnsignedShort(byArray, n7)));
            }
        }
        while (this.cattrs != null) {
            Label[] labelArray = this.cattrs.getLabels();
            if (labelArray == null) continue;
            for (n3 = labelArray.length - 1; n3 >= 0; --n3) {
                if (labelArray[n3].resized) continue;
                labelArray[n3].position = CodeWriter.getNewOffset(nArray3, nArray4, 0, labelArray[n3].position);
                labelArray[n3].resized = true;
            }
        }
        this.code = byteVector;
        return nArray;
    }

    static int readUnsignedShort(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF;
    }

    static short readShort(byte[] byArray, int n2) {
        return (short)((byArray[n2] & 0xFF) << 8 | byArray[n2 + 1] & 0xFF);
    }

    static int readInt(byte[] byArray, int n2) {
        return (byArray[n2] & 0xFF) << 24 | (byArray[n2 + 1] & 0xFF) << 16 | (byArray[n2 + 2] & 0xFF) << 8 | byArray[n2 + 3] & 0xFF;
    }

    static void writeShort(byte[] byArray, int n2, int n3) {
        byArray[n2] = (byte)(n3 >>> 8);
        byArray[n2 + 1] = (byte)n3;
    }

    static int getNewOffset(int[] nArray, int[] nArray2, int n2, int n3) {
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (n2 < nArray[i2] && nArray[i2] <= n3) {
                n4 += nArray2[i2];
                continue;
            }
            if (n3 >= nArray[i2] || nArray[i2] > n2) continue;
            n4 -= nArray2[i2];
        }
        return n4;
    }

    public int getCodeSize() {
        return this.code.length;
    }

    public byte[] getCode() {
        return this.code.data;
    }

    static {
        int[] nArray = new int[202];
        String string = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            nArray[i2] = string.charAt(i2) - 69;
        }
        SIZE = nArray;
    }
}

