/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm;

import java.lang.reflect.Method;

public class Type {
    public static final int VOID = 0;
    public static final int BOOLEAN = 1;
    public static final int CHAR = 2;
    public static final int BYTE = 3;
    public static final int SHORT = 4;
    public static final int INT = 5;
    public static final int FLOAT = 6;
    public static final int LONG = 7;
    public static final int DOUBLE = 8;
    public static final int ARRAY = 9;
    public static final int OBJECT = 10;
    public static final Type VOID_TYPE = new Type(0);
    public static final Type BOOLEAN_TYPE = new Type(1);
    public static final Type CHAR_TYPE = new Type(2);
    public static final Type BYTE_TYPE = new Type(3);
    public static final Type SHORT_TYPE = new Type(4);
    public static final Type INT_TYPE = new Type(5);
    public static final Type FLOAT_TYPE = new Type(6);
    public static final Type LONG_TYPE = new Type(7);
    public static final Type DOUBLE_TYPE = new Type(8);
    private final int sort;
    private char[] buf;
    private int off;
    private int len;

    private Type(int n2) {
        this.sort = n2;
        this.len = 1;
    }

    private Type(int n2, char[] cArray, int n3, int n4) {
        this.sort = n2;
        this.buf = cArray;
        this.off = n3;
        this.len = n4;
    }

    public static Type getType(String string) {
        return Type.getType(string.toCharArray(), 0);
    }

    public static Type getType(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return INT_TYPE;
            }
            if (clazz == Void.TYPE) {
                return VOID_TYPE;
            }
            if (clazz == Boolean.TYPE) {
                return BOOLEAN_TYPE;
            }
            if (clazz == Byte.TYPE) {
                return BYTE_TYPE;
            }
            if (clazz == Character.TYPE) {
                return CHAR_TYPE;
            }
            if (clazz == Short.TYPE) {
                return SHORT_TYPE;
            }
            if (clazz == Double.TYPE) {
                return DOUBLE_TYPE;
            }
            if (clazz == Float.TYPE) {
                return FLOAT_TYPE;
            }
            return LONG_TYPE;
        }
        return Type.getType(Type.getDescriptor(clazz));
    }

    public static Type[] getArgumentTypes(String string) {
        char c2;
        char[] cArray = string.toCharArray();
        int n2 = 1;
        int n3 = 0;
        while ((c2 = cArray[n2++]) != ')') {
            if (c2 == 'L') {
                while (cArray[n2++] != ';') {
                }
                ++n3;
                continue;
            }
            if (c2 == '[') continue;
            ++n3;
        }
        Type[] typeArray = new Type[n3];
        n2 = 1;
        n3 = 0;
        while (cArray[n2] != ')') {
            typeArray[n3] = Type.getType(cArray, n2);
            n2 += typeArray[n3].len;
            ++n3;
        }
        return typeArray;
    }

    public static Type[] getArgumentTypes(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        Type[] typeArray = new Type[classArray.length];
        for (int i2 = classArray.length - 1; i2 >= 0; --i2) {
            typeArray[i2] = Type.getType(classArray[i2]);
        }
        return typeArray;
    }

    public static Type getReturnType(String string) {
        char[] cArray = string.toCharArray();
        return Type.getType(cArray, string.indexOf(41) + 1);
    }

    public static Type getReturnType(Method method) {
        return Type.getType(method.getReturnType());
    }

    private static Type getType(char[] cArray, int n2) {
        switch (cArray[n2]) {
            case 'V': {
                return VOID_TYPE;
            }
            case 'Z': {
                return BOOLEAN_TYPE;
            }
            case 'C': {
                return CHAR_TYPE;
            }
            case 'B': {
                return BYTE_TYPE;
            }
            case 'S': {
                return SHORT_TYPE;
            }
            case 'I': {
                return INT_TYPE;
            }
            case 'F': {
                return FLOAT_TYPE;
            }
            case 'J': {
                return LONG_TYPE;
            }
            case 'D': {
                return DOUBLE_TYPE;
            }
            case '[': {
                int n3 = 1;
                while (cArray[n2 + n3] == '[') {
                    ++n3;
                }
                if (cArray[n2 + n3] == 'L') {
                    ++n3;
                    while (cArray[n2 + n3] != ';') {
                        ++n3;
                    }
                }
                return new Type(9, cArray, n2, n3 + 1);
            }
        }
        int n4 = 1;
        while (cArray[n2 + n4] != ';') {
            ++n4;
        }
        return new Type(10, cArray, n2, n4 + 1);
    }

    public int getSort() {
        return this.sort;
    }

    public int getDimensions() {
        int n2 = 1;
        while (this.buf[this.off + n2] == '[') {
            ++n2;
        }
        return n2;
    }

    public Type getElementType() {
        return Type.getType(this.buf, this.off + this.getDimensions());
    }

    public String getClassName() {
        switch (this.sort) {
            case 0: {
                return "void";
            }
            case 1: {
                return "boolean";
            }
            case 2: {
                return "char";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 5: {
                return "int";
            }
            case 6: {
                return "float";
            }
            case 7: {
                return "long";
            }
            case 8: {
                return "double";
            }
            case 9: {
                StringBuffer stringBuffer = new StringBuffer(this.getElementType().getClassName());
                for (int i2 = this.getDimensions(); i2 > 0; --i2) {
                    stringBuffer.append("[]");
                }
                return stringBuffer.toString();
            }
        }
        return new String(this.buf, this.off + 1, this.len - 2).replace('/', '.');
    }

    public String getInternalName() {
        return new String(this.buf, this.off + 1, this.len - 2);
    }

    public String getDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        this.getDescriptor(stringBuffer);
        return stringBuffer.toString();
    }

    public static String getMethodDescriptor(Type type, Type[] typeArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < typeArray.length; ++i2) {
            typeArray[i2].getDescriptor(stringBuffer);
        }
        stringBuffer.append(')');
        type.getDescriptor(stringBuffer);
        return stringBuffer.toString();
    }

    private void getDescriptor(StringBuffer stringBuffer) {
        switch (this.sort) {
            case 0: {
                stringBuffer.append('V');
                return;
            }
            case 1: {
                stringBuffer.append('Z');
                return;
            }
            case 2: {
                stringBuffer.append('C');
                return;
            }
            case 3: {
                stringBuffer.append('B');
                return;
            }
            case 4: {
                stringBuffer.append('S');
                return;
            }
            case 5: {
                stringBuffer.append('I');
                return;
            }
            case 6: {
                stringBuffer.append('F');
                return;
            }
            case 7: {
                stringBuffer.append('J');
                return;
            }
            case 8: {
                stringBuffer.append('D');
                return;
            }
        }
        stringBuffer.append(this.buf, this.off, this.len);
    }

    public static String getInternalName(Class clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static String getDescriptor(Class clazz) {
        StringBuffer stringBuffer = new StringBuffer();
        Type.getDescriptor(stringBuffer, clazz);
        return stringBuffer.toString();
    }

    public static String getMethodDescriptor(Method method) {
        Class<?>[] classArray = method.getParameterTypes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            Type.getDescriptor(stringBuffer, classArray[i2]);
        }
        stringBuffer.append(')');
        Type.getDescriptor(stringBuffer, method.getReturnType());
        return stringBuffer.toString();
    }

    private static void getDescriptor(StringBuffer stringBuffer, Class clazz) {
        Class<?> clazz2 = clazz;
        while (true) {
            if (clazz2.isPrimitive()) {
                int n2 = clazz2 == Integer.TYPE ? 73 : (clazz2 == Void.TYPE ? 86 : (clazz2 == Boolean.TYPE ? 90 : (clazz2 == Byte.TYPE ? 66 : (clazz2 == Character.TYPE ? 67 : (clazz2 == Short.TYPE ? 83 : (clazz2 == Double.TYPE ? 68 : (clazz2 == Float.TYPE ? 70 : 74)))))));
                stringBuffer.append((char)n2);
                return;
            }
            if (!clazz2.isArray()) break;
            stringBuffer.append('[');
            clazz2 = clazz2.getComponentType();
        }
        stringBuffer.append('L');
        String string = clazz2.getName();
        int n3 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string.charAt(i2);
            stringBuffer.append(c2 == '.' ? (char)'/' : (char)c2);
        }
        stringBuffer.append(';');
    }

    public int getSize() {
        return this.sort == 7 || this.sort == 8 ? 2 : 1;
    }

    public int getOpcode(int n2) {
        if (n2 == 46 || n2 == 79) {
            switch (this.sort) {
                case 1: 
                case 3: {
                    return n2 + 5;
                }
                case 2: {
                    return n2 + 6;
                }
                case 4: {
                    return n2 + 7;
                }
                case 5: {
                    return n2;
                }
                case 6: {
                    return n2 + 2;
                }
                case 7: {
                    return n2 + 1;
                }
                case 8: {
                    return n2 + 3;
                }
            }
            return n2 + 4;
        }
        switch (this.sort) {
            case 0: {
                return n2 + 5;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return n2;
            }
            case 6: {
                return n2 + 2;
            }
            case 7: {
                return n2 + 1;
            }
            case 8: {
                return n2 + 3;
            }
        }
        return n2 + 4;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Type)) {
            return false;
        }
        Type type = (Type)object;
        if (this.sort != type.sort) {
            return false;
        }
        if (this.sort == 10 || this.sort == 9) {
            if (this.len != type.len) {
                return false;
            }
            int n2 = this.off;
            int n3 = type.off;
            int n4 = n2 + this.len;
            while (n2 < n4) {
                if (this.buf[n2] != type.buf[n3]) {
                    return false;
                }
                ++n2;
                ++n3;
            }
        }
        return true;
    }

    public int hashCode() {
        int n2 = 13 * this.sort;
        if (this.sort == 10 || this.sort == 9) {
            int n3;
            int n4 = n3 + this.len;
            for (n3 = this.off; n3 < n4; ++n3) {
                n2 = 17 * (n2 + this.buf[n3]);
            }
        }
        return n2;
    }

    public String toString() {
        return this.getDescriptor();
    }
}

