/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.List;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;

public class Annotation {
    public String type;
    public List elementValues = new ArrayList();

    public Annotation() {
    }

    public Annotation(String string) {
        this.type = string;
    }

    public void add(String string, Object object) {
        this.elementValues.add(new Object[]{string, object});
    }

    public int read(ClassReader classReader, int n2, char[] cArray) {
        this.type = classReader.readUTF8(n2, cArray);
        int n3 = classReader.readUnsignedShort(n2 + 2);
        int[] nArray = new int[]{n2 += 4};
        for (int i2 = 0; i2 < n3; ++i2) {
            String string = classReader.readUTF8(nArray[0], cArray);
            nArray[0] = nArray[0] + 2;
            this.elementValues.add(new Object[]{string, Annotation.readValue(classReader, nArray, cArray)});
        }
        return nArray[0];
    }

    public void write(ByteVector byteVector, ClassWriter classWriter) {
        byteVector.putShort(classWriter.newUTF8(this.type));
        byteVector.putShort(this.elementValues.size());
        for (int i2 = 0; i2 < this.elementValues.size(); ++i2) {
            Object[] objectArray = (Object[])this.elementValues.get(i2);
            byteVector.putShort(classWriter.newUTF8((String)objectArray[0]));
            Annotation.writeValue(byteVector, objectArray[1], classWriter);
        }
    }

    public static int readAnnotations(List list, ClassReader classReader, int n2, char[] cArray) {
        int n3 = classReader.readUnsignedShort(n2);
        n2 += 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            Annotation annotation = new Annotation();
            n2 = annotation.read(classReader, n2, cArray);
            list.add(annotation);
        }
        return n2;
    }

    public static void readParameterAnnotations(List list, ClassReader classReader, int n2, char[] cArray) {
        int n3 = classReader.b[n2++] & 0xFF;
        for (int i2 = 0; i2 < n3; ++i2) {
            ArrayList arrayList = new ArrayList();
            n2 = Annotation.readAnnotations(arrayList, classReader, n2, cArray);
            list.add(arrayList);
        }
    }

    public static ByteVector writeAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putShort(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            ((Annotation)list.get(i2)).write(byteVector, classWriter);
        }
        return byteVector;
    }

    public static ByteVector writeParametersAnnotations(ByteVector byteVector, List list, ClassWriter classWriter) {
        byteVector.putByte(list.size());
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Annotation.writeAnnotations(byteVector, (List)list.get(i2), classWriter);
        }
        return byteVector;
    }

    public static String stringAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        if (list.size() > 0) {
            for (int i2 = 0; i2 < list.size(); ++i2) {
                stringBuffer.append('\n').append(list.get(i2));
            }
        } else {
            stringBuffer.append("<none>");
        }
        return stringBuffer.toString();
    }

    public static String stringParameterAnnotations(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        for (int i2 = 0; i2 < list.size(); ++i2) {
            stringBuffer.append(string).append(Annotation.stringAnnotations((List)list.get(i2)));
            string = ", ";
        }
        return stringBuffer.toString();
    }

    protected static Object readValue(ClassReader classReader, int[] nArray, char[] cArray) {
        Object[] objectArray = null;
        int n2 = nArray[0];
        nArray[0] = n2 + 1;
        int n3 = classReader.readByte(n2);
        block0 : switch (n3) {
            case 68: 
            case 70: 
            case 73: 
            case 74: {
                objectArray = classReader.readConst(classReader.readUnsignedShort(nArray[0]), cArray);
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 66: {
                objectArray = new Byte((byte)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 67: {
                objectArray = new Character((char)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 83: {
                objectArray = new Short((short)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 90: {
                objectArray = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))) == 0 ? Boolean.FALSE : Boolean.TRUE;
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 115: {
                objectArray = classReader.readUTF8(nArray[0], cArray);
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 101: {
                objectArray = new EnumConstValue(classReader.readUTF8(nArray[0], cArray), classReader.readUTF8(nArray[0] + 2, cArray));
                nArray[0] = nArray[0] + 4;
                break;
            }
            case 99: {
                objectArray = Type.getType(classReader.readUTF8(nArray[0], cArray));
                nArray[0] = nArray[0] + 2;
                break;
            }
            case 64: {
                objectArray = new Annotation();
                nArray[0] = ((Annotation)objectArray).read(classReader, nArray[0], cArray);
                break;
            }
            case 91: {
                Object[] objectArray2;
                int n4 = classReader.readUnsignedShort(nArray[0]);
                nArray[0] = nArray[0] + 2;
                int n5 = classReader.readByte(nArray[0]);
                switch (n5) {
                    case 73: {
                        int[] nArray2 = new int[n4];
                        for (int i2 = 0; i2 < n4; ++i2) {
                            nArray[0] = nArray[0] + 1;
                            nArray2[i2] = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = nArray2;
                        break block0;
                    }
                    case 74: {
                        long[] lArray = new long[n4];
                        for (int i3 = 0; i3 < n4; ++i3) {
                            nArray[0] = nArray[0] + 1;
                            lArray[i3] = classReader.readLong(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = lArray;
                        break block0;
                    }
                    case 68: {
                        double[] dArray = new double[n4];
                        for (int i4 = 0; i4 < n4; ++i4) {
                            nArray[0] = nArray[0] + 1;
                            dArray[i4] = Double.longBitsToDouble(classReader.readLong(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = dArray;
                        break block0;
                    }
                    case 70: {
                        float[] fArray = new float[n4];
                        for (int i5 = 0; i5 < n4; ++i5) {
                            nArray[0] = nArray[0] + 1;
                            fArray[i5] = Float.intBitsToFloat(classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = fArray;
                        break block0;
                    }
                    case 66: {
                        byte[] byArray = new byte[n4];
                        for (int i6 = 0; i6 < n4; ++i6) {
                            nArray[0] = nArray[0] + 1;
                            byArray[i6] = (byte)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = byArray;
                        break block0;
                    }
                    case 67: {
                        char[] cArray2 = new char[n4];
                        for (int i7 = 0; i7 < n4; ++i7) {
                            nArray[0] = nArray[0] + 1;
                            cArray2[i7] = (char)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = cArray2;
                        break block0;
                    }
                    case 83: {
                        short[] sArray = new short[n4];
                        for (int i8 = 0; i8 < n4; ++i8) {
                            nArray[0] = nArray[0] + 1;
                            sArray[i8] = (short)classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0])));
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = sArray;
                        break block0;
                    }
                    case 90: {
                        boolean[] blArray = new boolean[n4];
                        for (int i9 = 0; i9 < n4; ++i9) {
                            nArray[0] = nArray[0] + 1;
                            blArray[i9] = classReader.readInt(classReader.getItem(classReader.readUnsignedShort(nArray[0]))) != 0;
                            nArray[0] = nArray[0] + 2;
                        }
                        objectArray = blArray;
                        break block0;
                    }
                }
                objectArray = objectArray2 = new Object[n4];
                for (int i10 = 0; i10 < n4; ++i10) {
                    objectArray2[i10] = Annotation.readValue(classReader, nArray, cArray);
                }
                break;
            }
        }
        return objectArray;
    }

    protected static ByteVector writeValue(ByteVector byteVector, Object object, ClassWriter classWriter) {
        if (object instanceof String) {
            byteVector.putByte(115);
            byteVector.putShort(classWriter.newUTF8((String)object));
        } else if (object instanceof EnumConstValue) {
            byteVector.putByte(101);
            byteVector.putShort(classWriter.newUTF8(((EnumConstValue)object).typeName));
            byteVector.putShort(classWriter.newUTF8(((EnumConstValue)object).constName));
        } else if (object instanceof Type) {
            byteVector.putByte(99);
            byteVector.putShort(classWriter.newUTF8(((Type)object).getDescriptor()));
        } else if (object instanceof Annotation) {
            byteVector.putByte(64);
            ((Annotation)object).write(byteVector, classWriter);
        } else if (object instanceof Object[]) {
            byteVector.putByte(91);
            Object[] objectArray = (Object[])object;
            byteVector.putShort(objectArray.length);
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                Annotation.writeValue(byteVector, objectArray[i2], classWriter);
            }
        } else if (object instanceof byte[]) {
            byteVector.putByte(91);
            byte[] byArray = (byte[])object;
            byteVector.putShort(byArray.length);
            for (int i3 = 0; i3 < byArray.length; ++i3) {
                byteVector.putByte(66);
                byteVector.putShort(classWriter.newConstInt(byArray[i3]));
            }
        } else if (object instanceof short[]) {
            byteVector.putByte(91);
            short[] sArray = (short[])object;
            byteVector.putShort(sArray.length);
            for (int i4 = 0; i4 < sArray.length; ++i4) {
                byteVector.putByte(83);
                byteVector.putShort(classWriter.newConstInt(sArray[i4]));
            }
        } else if (object instanceof int[]) {
            byteVector.putByte(91);
            int[] nArray = (int[])object;
            byteVector.putShort(nArray.length);
            for (int i5 = 0; i5 < nArray.length; ++i5) {
                byteVector.putByte(73);
                byteVector.putShort(classWriter.newConstInt(nArray[i5]));
            }
        } else if (object instanceof char[]) {
            byteVector.putByte(91);
            char[] cArray = (char[])object;
            byteVector.putShort(cArray.length);
            for (int i6 = 0; i6 < cArray.length; ++i6) {
                byteVector.putByte(67);
                byteVector.putShort(classWriter.newConstInt(cArray[i6]));
            }
        } else if (object instanceof boolean[]) {
            byteVector.putByte(91);
            boolean[] blArray = (boolean[])object;
            byteVector.putShort(blArray.length);
            for (int i7 = 0; i7 < blArray.length; ++i7) {
                byteVector.putByte(90);
                byteVector.putShort(classWriter.newConstInt(blArray[i7] ? 1 : 0));
            }
        } else if (object instanceof long[]) {
            byteVector.putByte(91);
            long[] lArray = (long[])object;
            byteVector.putShort(lArray.length);
            for (int i8 = 0; i8 < lArray.length; ++i8) {
                byteVector.putByte(74);
                byteVector.putShort(classWriter.newConstLong(lArray[i8]));
            }
        } else if (object instanceof float[]) {
            byteVector.putByte(91);
            float[] fArray = (float[])object;
            byteVector.putShort(fArray.length);
            for (int i9 = 0; i9 < fArray.length; ++i9) {
                byteVector.putByte(70);
                byteVector.putShort(classWriter.newConstFloat(fArray[i9]));
            }
        } else if (object instanceof double[]) {
            byteVector.putByte(91);
            double[] dArray = (double[])object;
            byteVector.putShort(dArray.length);
            for (int i10 = 0; i10 < dArray.length; ++i10) {
                byteVector.putByte(68);
                byteVector.putShort(classWriter.newConstDouble(dArray[i10]));
            }
        } else {
            int n2 = -1;
            if (object instanceof Integer) {
                n2 = 73;
            } else if (object instanceof Byte) {
                n2 = 66;
            } else if (object instanceof Character) {
                n2 = 67;
            } else if (object instanceof Double) {
                n2 = 68;
            } else if (object instanceof Float) {
                n2 = 70;
            } else if (object instanceof Long) {
                n2 = 74;
            } else if (object instanceof Short) {
                n2 = 83;
            } else if (object instanceof Boolean) {
                n2 = 90;
            }
            byteVector.putByte(n2);
            byteVector.putShort(classWriter.newConst(object));
        }
        return byteVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("@").append(this.type);
        if (this.elementValues.size() > 0) {
            stringBuffer.append(" ( ");
            String string = "";
            for (int i2 = 0; i2 < this.elementValues.size(); ++i2) {
                Object[] objectArray = (Object[])this.elementValues.get(i2);
                if (this.elementValues.size() != 1 && !"value".equals(this.elementValues.get(0))) {
                    stringBuffer.append(string).append(objectArray[0]).append(" = ");
                }
                if (objectArray[1] instanceof Object[]) {
                    Object[] objectArray2 = (Object[])objectArray[1];
                    stringBuffer.append("{");
                    String string2 = "";
                    for (int i3 = 0; i3 < objectArray2.length; ++i3) {
                        stringBuffer.append(string2).append(objectArray2[i3]);
                        string2 = ", ";
                    }
                    stringBuffer.append("}");
                } else {
                    stringBuffer.append(objectArray[1]);
                }
                string = ", ";
            }
            stringBuffer.append(" )");
        }
        return stringBuffer.toString();
    }

    public static class EnumConstValue {
        public String typeName;
        public String constName;

        public EnumConstValue(String string, String string2) {
            this.typeName = string;
            this.constName = string2;
        }

        public String toString() {
            return this.typeName + ":" + this.constName;
        }
    }
}

