/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.LocalVariableType;

public class LocalVariableTypeTableAttribute
extends Attribute {
    protected List types = new ArrayList();

    public LocalVariableTypeTableAttribute() {
        super("LocalVariableTypeTable");
    }

    public List getTypes() {
        return this.types;
    }

    protected Label[] getLabels() {
        HashSet<Label> hashSet = new HashSet<Label>();
        for (int i2 = 0; i2 < this.types.size(); ++i2) {
            LocalVariableType localVariableType = (LocalVariableType)this.types.get(i2);
            hashSet.add(localVariableType.getStart());
            hashSet.add(localVariableType.getEnd());
        }
        return hashSet.toArray(new Label[hashSet.size()]);
    }

    protected Attribute read(ClassReader classReader, int n2, int n3, char[] cArray, int n4, Label[] labelArray) {
        int n5 = classReader.readUnsignedShort(n2);
        n2 += 2;
        LocalVariableTypeTableAttribute localVariableTypeTableAttribute = new LocalVariableTypeTableAttribute();
        for (int i2 = 0; i2 < n5; ++i2) {
            LocalVariableType localVariableType = new LocalVariableType();
            int n6 = classReader.readUnsignedShort(n2);
            int n7 = classReader.readUnsignedShort(n2 + 2);
            localVariableType.start = this.getLabel(labelArray, n6);
            localVariableType.end = this.getLabel(labelArray, n6 + n7);
            localVariableType.name = classReader.readUTF8(n2 + 4, cArray);
            localVariableType.signature = classReader.readUTF8(n2 + 6, cArray);
            localVariableType.index = classReader.readUnsignedShort(n2 + 8);
            n2 += 10;
            this.types.add(localVariableType);
        }
        return localVariableTypeTableAttribute;
    }

    protected ByteVector write(ClassWriter classWriter, byte[] byArray, int n2, int n3, int n4) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.types.size());
        for (int i2 = 0; i2 < this.types.size(); ++i2) {
            LocalVariableType localVariableType = (LocalVariableType)this.types.get(i2);
            int n5 = localVariableType.getStart().getOffset();
            byteVector.putShort(n5);
            byteVector.putShort(localVariableType.getEnd().getOffset() - n5);
            byteVector.putUTF8(localVariableType.getName());
            byteVector.putUTF8(localVariableType.getSignature());
            byteVector.putShort(localVariableType.getIndex());
        }
        return byteVector;
    }

    private Label getLabel(Label[] labelArray, int n2) {
        Label label = labelArray[n2];
        if (label == null) {
            labelArray[n2] = label = new Label();
        }
        return label;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("LocalVariableTypeTable[");
        for (int i2 = 0; i2 < this.types.size(); ++i2) {
            stringBuffer.append('\n').append('[').append(this.types.get(i2)).append(']');
        }
        stringBuffer.append("\n]");
        return stringBuffer.toString();
    }
}

