/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.asm.attrs;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.ByteVector;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.attrs.StackMapType;

public class StackMapFrame {
    public Label label;
    public List locals = new ArrayList();
    public List stack = new ArrayList();

    public int read(ClassReader classReader, int n2, char[] cArray, int n3, Label[] labelArray) {
        int n4 = classReader.readUnsignedShort(n2);
        n2 += 2;
        if (labelArray[n4] == null) {
            labelArray[n4] = new Label();
        }
        this.label = labelArray[n4];
        n2 = this.readTypeInfo(classReader, n2, this.locals, labelArray, cArray, classReader.readUnsignedShort(n3 + 2));
        n2 = this.readTypeInfo(classReader, n2, this.stack, labelArray, cArray, classReader.readUnsignedShort(n3));
        return n2;
    }

    public void write(ClassWriter classWriter, int n2, int n3, ByteVector byteVector) {
        byteVector.putShort(this.label.getOffset());
        this.writeTypeInfo(byteVector, classWriter, this.locals, n3);
        this.writeTypeInfo(byteVector, classWriter, this.stack, n2);
    }

    public void getLabels(Set set) {
        set.add(this.label);
        this.getTypeInfoLabels(set, this.locals);
        this.getTypeInfoLabels(set, this.stack);
    }

    private void getTypeInfoLabels(Set set, List list) {
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            StackMapType stackMapType = (StackMapType)iterator.next();
            if (stackMapType.getType() != 8) continue;
            set.add(stackMapType.getLabel());
        }
    }

    private int readTypeInfo(ClassReader classReader, int n2, List list, Label[] labelArray, char[] cArray, int n3) {
        int n4 = 0;
        if (n3 > 65535) {
            n4 = classReader.readInt(n2);
            n2 += 4;
        } else {
            n4 = classReader.readUnsignedShort(n2);
            n2 += 2;
        }
        block4: for (int i2 = 0; i2 < n4; ++i2) {
            int n5 = classReader.readByte(n2++);
            StackMapType stackMapType = StackMapType.getTypeInfo(n5);
            list.add(stackMapType);
            switch (n5) {
                case 7: {
                    stackMapType.setObject(classReader.readClass(n2, cArray));
                    n2 += 2;
                    continue block4;
                }
                case 8: {
                    int n6 = classReader.readUnsignedShort(n2);
                    n2 += 2;
                    if (labelArray[n6] == null) {
                        labelArray[n6] = new Label();
                    }
                    stackMapType.setLabel(labelArray[n6]);
                }
            }
        }
        return n2;
    }

    private void writeTypeInfo(ByteVector byteVector, ClassWriter classWriter, List list, int n2) {
        if (n2 > 65535) {
            byteVector.putInt(list.size());
        } else {
            byteVector.putShort(list.size());
        }
        block4: for (int i2 = 0; i2 < list.size(); ++i2) {
            StackMapType stackMapType = (StackMapType)list.get(i2);
            byteVector.putByte(stackMapType.getType());
            switch (stackMapType.getType()) {
                case 7: {
                    byteVector.putShort(classWriter.newClass(stackMapType.getObject()));
                    continue block4;
                }
                case 8: {
                    byteVector.putShort(stackMapType.getLabel().getOffset());
                }
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Frame:L");
        stringBuffer.append(System.identityHashCode(this.label));
        stringBuffer.append(" locals").append(this.locals);
        stringBuffer.append(" stack").append(this.stack);
        return stringBuffer.toString();
    }
}

