/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import org.postgresql.core.ParameterList;
import org.postgresql.core.v3.CompositeParameterList;
import org.postgresql.core.v3.SimpleParameterList;
import org.postgresql.core.v3.SimpleQuery;
import org.postgresql.core.v3.V3Query;

class CompositeQuery
implements V3Query {
    private final SimpleQuery[] subqueries;
    private final int[] offsets;

    CompositeQuery(SimpleQuery[] subqueries, int[] offsets) {
        this.subqueries = subqueries;
        this.offsets = offsets;
    }

    public void close() {
        int i2 = 0;
        while (i2 < this.subqueries.length) {
            this.subqueries[i2].close();
            ++i2;
        }
    }

    public ParameterList createParameterList() {
        SimpleParameterList[] subparams = new SimpleParameterList[this.subqueries.length];
        int i2 = 0;
        while (i2 < this.subqueries.length) {
            subparams[i2] = (SimpleParameterList)this.subqueries[i2].createParameterList();
            ++i2;
        }
        return new CompositeParameterList(subparams, this.offsets);
    }

    public SimpleQuery[] getSubqueries() {
        return this.subqueries;
    }

    public String toString() {
        return this.toString(null);
    }

    public String toString(ParameterList parameters) {
        StringBuffer sbuf = new StringBuffer(this.subqueries[0].toString());
        int i2 = 1;
        while (i2 < this.subqueries.length) {
            sbuf.append(';');
            sbuf.append(this.subqueries[i2]);
            ++i2;
        }
        return sbuf.toString();
    }
}

