/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.core.v3;

import java.io.IOException;
import java.net.ConnectException;
import java.sql.SQLException;
import java.util.Properties;
import org.postgresql.Driver;
import org.postgresql.core.ConnectionFactory;
import org.postgresql.core.Encoding;
import org.postgresql.core.PGStream;
import org.postgresql.core.ProtocolConnection;
import org.postgresql.core.Utils;
import org.postgresql.core.v3.ProtocolConnectionImpl;
import org.postgresql.util.GT;
import org.postgresql.util.MD5Digest;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;
import org.postgresql.util.PSQLWarning;
import org.postgresql.util.ServerErrorMessage;
import org.postgresql.util.UnixCrypt;

public class ConnectionFactoryImpl
extends ConnectionFactory {
    private static final int AUTH_REQ_OK = 0;
    private static final int AUTH_REQ_KRB4 = 1;
    private static final int AUTH_REQ_KRB5 = 2;
    private static final int AUTH_REQ_PASSWORD = 3;
    private static final int AUTH_REQ_CRYPT = 4;
    private static final int AUTH_REQ_MD5 = 5;
    private static final int AUTH_REQ_SCM = 6;

    private void doAuthentication(PGStream pgStream, String user, String password) throws IOException, SQLException {
        block10: while (true) {
            int beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 69: {
                    int l_elen = pgStream.ReceiveIntegerR(4);
                    if (l_elen > 30000) {
                        throw new UnsupportedProtocolException();
                    }
                    ServerErrorMessage errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4));
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ErrorMessage(" + errorMsg + ")");
                    }
                    throw new PSQLException(errorMsg);
                }
                case 82: {
                    int l_msgLen = pgStream.ReceiveIntegerR(4);
                    int areq = pgStream.ReceiveIntegerR(4);
                    switch (areq) {
                        case 4: {
                            byte[] rst = new byte[]{(byte)pgStream.ReceiveChar(), (byte)pgStream.ReceiveChar()};
                            String salt = new String(rst, 0, 2, "US-ASCII");
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqCrypt(salt='" + salt + "')");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            String result = UnixCrypt.crypt(salt, password);
                            byte[] encodedResult = result.getBytes("US-ASCII");
                            if (Driver.logDebug) {
                                Driver.debug(" FE=> Password(crypt='" + result + "')");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedResult.length + 1);
                            pgStream.Send(encodedResult);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 5: {
                            byte[] md5Salt = pgStream.Receive(4);
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqMD5(salt=" + Utils.toHexString(md5Salt) + ")");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] digest = MD5Digest.encode(user, password, md5Salt);
                            if (Driver.logDebug) {
                                Driver.debug(" FE=> Password(md5digest=" + new String(digest, "US-ASCII") + ")");
                            }
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + digest.length + 1);
                            pgStream.Send(digest);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 3: {
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationReqPassword");
                                Driver.debug(" FE=> Password(password=<not shown>)");
                            }
                            if (password == null) {
                                throw new PSQLException(GT.tr("The server requested password-based authentication, but no password was provided."), PSQLState.CONNECTION_REJECTED);
                            }
                            byte[] encodedPassword = password.getBytes("US-ASCII");
                            pgStream.SendChar(112);
                            pgStream.SendInteger4(4 + encodedPassword.length + 1);
                            pgStream.Send(encodedPassword);
                            pgStream.SendChar(0);
                            pgStream.flush();
                            continue block10;
                        }
                        case 0: {
                            if (Driver.logDebug) {
                                Driver.debug(" <=BE AuthenticationOk");
                            }
                            return;
                        }
                    }
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE AuthenticationReq (unsupported type " + areq + ")");
                    }
                    throw new PSQLException(GT.tr("The authentication type {0} is not supported. Check that you have configured the pg_hba.conf file to include the client''s IP address or subnet, and that it is using an authentication scheme supported by the driver.", new Integer(areq)), PSQLState.CONNECTION_REJECTED);
                }
            }
            break;
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private PGStream enableSSL(PGStream pgStream, boolean requireSSL, Properties info) throws IOException, SQLException {
        if (Driver.logDebug) {
            Driver.debug(" FE=> SSLRequest");
        }
        pgStream.SendInteger4(8);
        pgStream.SendInteger2(1234);
        pgStream.SendInteger2(5679);
        pgStream.flush();
        int beresp = pgStream.ReceiveChar();
        switch (beresp) {
            case 69: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLError");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                pgStream.close();
                return new PGStream(pgStream.getHost(), pgStream.getPort());
            }
            case 78: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLRefused");
                }
                if (requireSSL) {
                    throw new PSQLException(GT.tr("The server does not support SSL."), PSQLState.CONNECTION_FAILURE);
                }
                return pgStream;
            }
            case 83: {
                if (Driver.logDebug) {
                    Driver.debug(" <=BE SSLOk");
                }
                Driver.makeSSL(pgStream, info);
                return pgStream;
            }
        }
        throw new PSQLException(GT.tr("An error occured while setting up the SSL connection."), PSQLState.CONNECTION_FAILURE);
    }

    public ProtocolConnection openConnectionImpl(String host, int port, String user, String database, Properties info) throws SQLException {
        boolean requireSSL;
        boolean trySSL = requireSSL = info.getProperty("ssl") != null;
        if (Driver.logDebug) {
            Driver.debug("Trying to establish a protocol version 3 connection to " + host + ":" + port);
        }
        if (!Driver.sslEnabled()) {
            if (requireSSL) {
                throw new PSQLException(GT.tr("The driver does not support SSL."), PSQLState.CONNECTION_FAILURE);
            }
            trySSL = false;
        }
        PGStream newStream = null;
        try {
            newStream = new PGStream(host, port);
            if (trySSL) {
                newStream = this.enableSSL(newStream, requireSSL, info);
            }
            String[][] params = new String[][]{{"user", user}, {"database", database}, {"client_encoding", "UNICODE"}, {"DateStyle", "ISO"}};
            this.sendStartupPacket(newStream, params);
            this.doAuthentication(newStream, user, info.getProperty("password"));
            ProtocolConnectionImpl protoConnection = new ProtocolConnectionImpl(newStream, user, database, info);
            this.readStartupMessages(newStream, protoConnection);
            return protoConnection;
        }
        catch (UnsupportedProtocolException unsupportedProtocolException) {
            if (Driver.logDebug) {
                Driver.debug("Protocol not supported, abandoning connection.");
            }
            try {
                newStream.close();
            }
            catch (IOException iOException) {}
            return null;
        }
        catch (ConnectException cex) {
            throw new PSQLException(GT.tr("Connection refused. Check that the hostname and port are correct and that the postmaster is accepting TCP/IP connections."), PSQLState.CONNECTION_REJECTED, (Throwable)cex);
        }
        catch (IOException ioe) {
            if (newStream != null) {
                try {
                    newStream.close();
                }
                catch (IOException iOException) {}
            }
            throw new PSQLException(GT.tr("The connection attempt failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT, (Throwable)ioe);
        }
        catch (SQLException se) {
            block17: {
                if (newStream == null) break block17;
                try {
                    newStream.close();
                }
                catch (IOException iOException) {}
            }
            throw se;
        }
    }

    private void readStartupMessages(PGStream pgStream, ProtocolConnectionImpl protoConnection) throws IOException, SQLException {
        int beresp;
        block12: while (true) {
            beresp = pgStream.ReceiveChar();
            switch (beresp) {
                case 90: {
                    if (pgStream.ReceiveIntegerR(4) != 5) {
                        throw new IOException("unexpected length of ReadyForQuery packet");
                    }
                    char tStatus = (char)pgStream.ReceiveChar();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ReadyForQuery(" + tStatus + ")");
                    }
                    switch (tStatus) {
                        case 'I': {
                            protoConnection.setTransactionState(0);
                            break;
                        }
                        case 'T': {
                            protoConnection.setTransactionState(1);
                            break;
                        }
                        case 'E': {
                            protoConnection.setTransactionState(2);
                            break;
                        }
                    }
                    return;
                }
                case 75: {
                    int l_msgLen = pgStream.ReceiveIntegerR(4);
                    if (l_msgLen != 12) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    int pid = pgStream.ReceiveIntegerR(4);
                    int ckey = pgStream.ReceiveIntegerR(4);
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE BackendKeyData(pid=" + pid + ",ckey=" + ckey + ")");
                    }
                    protoConnection.setBackendKeyData(pid, ckey);
                    continue block12;
                }
                case 69: {
                    int l_elen = pgStream.ReceiveIntegerR(4);
                    ServerErrorMessage l_errorMsg = new ServerErrorMessage(pgStream.ReceiveString(l_elen - 4));
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ErrorMessage(" + l_errorMsg + ")");
                    }
                    throw new PSQLException(l_errorMsg);
                }
                case 78: {
                    int l_nlen = pgStream.ReceiveIntegerR(4);
                    ServerErrorMessage l_warnMsg = new ServerErrorMessage(pgStream.ReceiveString(l_nlen - 4));
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE NoticeResponse(" + l_warnMsg + ")");
                    }
                    protoConnection.addWarning(new PSQLWarning(l_warnMsg));
                    continue block12;
                }
                case 83: {
                    int l_len = pgStream.ReceiveIntegerR(4);
                    String name = pgStream.ReceiveString();
                    String value = pgStream.ReceiveString();
                    if (Driver.logDebug) {
                        Driver.debug(" <=BE ParameterStatus(" + name + " = " + value + ")");
                    }
                    if (name.equals("server_version")) {
                        protoConnection.setServerVersion(value);
                        continue block12;
                    }
                    if (!name.equals("client_encoding")) continue block12;
                    if (!value.equals("UNICODE")) {
                        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
                    }
                    pgStream.setEncoding(Encoding.getDatabaseEncoding("UNICODE"));
                    continue block12;
                }
            }
            break;
        }
        if (Driver.logDebug) {
            Driver.debug("invalid message type=" + (char)beresp);
        }
        throw new PSQLException(GT.tr("Protocol error.  Session setup failed."), PSQLState.CONNECTION_UNABLE_TO_CONNECT);
    }

    private void sendStartupPacket(PGStream pgStream, String[][] params) throws IOException {
        if (Driver.logDebug) {
            String details = "";
            int i2 = 0;
            while (i2 < params.length) {
                if (i2 != 0) {
                    details = String.valueOf(details) + ", ";
                }
                details = String.valueOf(details) + params[i2][0] + "=" + params[i2][1];
                ++i2;
            }
            Driver.debug(" FE=> StartupPacket(" + details + ")");
        }
        int length = 8;
        byte[][] encodedParams = new byte[params.length * 2][];
        int i3 = 0;
        while (i3 < params.length) {
            encodedParams[i3 * 2] = params[i3][0].getBytes("US-ASCII");
            encodedParams[i3 * 2 + 1] = params[i3][1].getBytes("US-ASCII");
            length += encodedParams[i3 * 2].length + 1 + encodedParams[i3 * 2 + 1].length + 1;
            ++i3;
        }
        pgStream.SendInteger4(++length);
        pgStream.SendInteger2(3);
        pgStream.SendInteger2(0);
        int i4 = 0;
        while (i4 < encodedParams.length) {
            pgStream.Send(encodedParams[i4]);
            pgStream.SendChar(0);
            ++i4;
        }
        pgStream.SendChar(0);
        pgStream.flush();
    }

    private static class UnsupportedProtocolException
    extends IOException {
        UnsupportedProtocolException() {
        }
    }
}

