/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.geometric;

import java.io.Serializable;
import java.sql.SQLException;
import org.postgresql.geometric.PGpoint;
import org.postgresql.util.PGobject;
import org.postgresql.util.PGtokenizer;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon() {
        this.setType("polygon");
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public Object clone() {
        PGpoint[] ary = new PGpoint[this.points.length];
        int i2 = 0;
        while (i2 < this.points.length) {
            ary[i2] = (PGpoint)this.points[i2].clone();
            ++i2;
        }
        return new PGpolygon(ary);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p = (PGpolygon)obj;
            if (p.points.length != this.points.length) {
                return false;
            }
            int i2 = 0;
            while (i2 < this.points.length) {
                if (!this.points[i2].equals(p.points[i2])) {
                    return false;
                }
                ++i2;
            }
            return true;
        }
        return false;
    }

    public String getValue() {
        StringBuffer b2 = new StringBuffer();
        b2.append("(");
        int p = 0;
        while (p < this.points.length) {
            if (p > 0) {
                b2.append(",");
            }
            b2.append(this.points[p].toString());
            ++p;
        }
        b2.append(")");
        return b2.toString();
    }

    public int hashCode() {
        int hash = 0;
        int i2 = 0;
        while (i2 < this.points.length && i2 < 5) {
            hash ^= this.points[i2].hashCode();
            ++i2;
        }
        return hash;
    }

    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        int p = 0;
        while (p < npoints) {
            this.points[p] = new PGpoint(t.getToken(p));
            ++p;
        }
    }
}

