/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.UnsupportedEncodingException;

public class Base64 {
    public static final int NO_OPTIONS = 0;
    public static final int ENCODE = 1;
    public static final int DECODE = 0;
    public static final int DONT_BREAK_LINES = 8;
    private static final int MAX_LINE_LENGTH = 76;
    private static final byte EQUALS_SIGN = 61;
    private static final byte NEW_LINE = 10;
    private static final String PREFERRED_ENCODING = "UTF-8";
    private static final byte[] ALPHABET;
    private static final byte[] _NATIVE_ALPHABET;
    private static final byte[] DECODABET;
    private static final byte WHITE_SPACE_ENC = -5;
    private static final byte EQUALS_SIGN_ENC = -1;

    static {
        byte[] __bytes;
        _NATIVE_ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
        try {
            __bytes = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            __bytes = _NATIVE_ALPHABET;
        }
        ALPHABET = __bytes;
        byte[] byArray = new byte[127];
        byArray[0] = -9;
        byArray[1] = -9;
        byArray[2] = -9;
        byArray[3] = -9;
        byArray[4] = -9;
        byArray[5] = -9;
        byArray[6] = -9;
        byArray[7] = -9;
        byArray[8] = -9;
        byArray[9] = -5;
        byArray[10] = -5;
        byArray[11] = -9;
        byArray[12] = -9;
        byArray[13] = -5;
        byArray[14] = -9;
        byArray[15] = -9;
        byArray[16] = -9;
        byArray[17] = -9;
        byArray[18] = -9;
        byArray[19] = -9;
        byArray[20] = -9;
        byArray[21] = -9;
        byArray[22] = -9;
        byArray[23] = -9;
        byArray[24] = -9;
        byArray[25] = -9;
        byArray[26] = -9;
        byArray[27] = -9;
        byArray[28] = -9;
        byArray[29] = -9;
        byArray[30] = -9;
        byArray[31] = -9;
        byArray[32] = -5;
        byArray[33] = -9;
        byArray[34] = -9;
        byArray[35] = -9;
        byArray[36] = -9;
        byArray[37] = -9;
        byArray[38] = -9;
        byArray[39] = -9;
        byArray[40] = -9;
        byArray[41] = -9;
        byArray[42] = -9;
        byArray[43] = 62;
        byArray[44] = -9;
        byArray[45] = -9;
        byArray[46] = -9;
        byArray[47] = 63;
        byArray[48] = 52;
        byArray[49] = 53;
        byArray[50] = 54;
        byArray[51] = 55;
        byArray[52] = 56;
        byArray[53] = 57;
        byArray[54] = 58;
        byArray[55] = 59;
        byArray[56] = 60;
        byArray[57] = 61;
        byArray[58] = -9;
        byArray[59] = -9;
        byArray[60] = -9;
        byArray[61] = -1;
        byArray[62] = -9;
        byArray[63] = -9;
        byArray[64] = -9;
        byArray[66] = 1;
        byArray[67] = 2;
        byArray[68] = 3;
        byArray[69] = 4;
        byArray[70] = 5;
        byArray[71] = 6;
        byArray[72] = 7;
        byArray[73] = 8;
        byArray[74] = 9;
        byArray[75] = 10;
        byArray[76] = 11;
        byArray[77] = 12;
        byArray[78] = 13;
        byArray[79] = 14;
        byArray[80] = 15;
        byArray[81] = 16;
        byArray[82] = 17;
        byArray[83] = 18;
        byArray[84] = 19;
        byArray[85] = 20;
        byArray[86] = 21;
        byArray[87] = 22;
        byArray[88] = 23;
        byArray[89] = 24;
        byArray[90] = 25;
        byArray[91] = -9;
        byArray[92] = -9;
        byArray[93] = -9;
        byArray[94] = -9;
        byArray[95] = -9;
        byArray[96] = -9;
        byArray[97] = 26;
        byArray[98] = 27;
        byArray[99] = 28;
        byArray[100] = 29;
        byArray[101] = 30;
        byArray[102] = 31;
        byArray[103] = 32;
        byArray[104] = 33;
        byArray[105] = 34;
        byArray[106] = 35;
        byArray[107] = 36;
        byArray[108] = 37;
        byArray[109] = 38;
        byArray[110] = 39;
        byArray[111] = 40;
        byArray[112] = 41;
        byArray[113] = 42;
        byArray[114] = 43;
        byArray[115] = 44;
        byArray[116] = 45;
        byArray[117] = 46;
        byArray[118] = 47;
        byArray[119] = 48;
        byArray[120] = 49;
        byArray[121] = 50;
        byArray[122] = 51;
        byArray[123] = -9;
        byArray[124] = -9;
        byArray[125] = -9;
        byArray[126] = -9;
        DECODABET = byArray;
    }

    private Base64() {
    }

    public static byte[] decode(String s) {
        byte[] bytes;
        try {
            bytes = s.getBytes(PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            bytes = s.getBytes();
        }
        bytes = Base64.decode(bytes, 0, bytes.length);
        return bytes;
    }

    public static byte[] decode(byte[] source, int off, int len) {
        int len34 = len * 3 / 4;
        byte[] outBuff = new byte[len34];
        int outBuffPosn = 0;
        byte[] b4 = new byte[4];
        int b4Posn = 0;
        int i2 = 0;
        byte sbiCrop = 0;
        byte sbiDecode = 0;
        i2 = off;
        while (i2 < off + len) {
            sbiCrop = (byte)(source[i2] & 0x7F);
            sbiDecode = DECODABET[sbiCrop];
            if (sbiDecode >= -5) {
                if (sbiDecode >= -1) {
                    b4[b4Posn++] = sbiCrop;
                    if (b4Posn > 3) {
                        outBuffPosn += Base64.decode4to3(b4, 0, outBuff, outBuffPosn);
                        b4Posn = 0;
                        if (sbiCrop == 61) {
                            break;
                        }
                    }
                }
            } else {
                System.err.println("Bad Base64 input character at " + i2 + ": " + source[i2] + "(decimal)");
                return null;
            }
            ++i2;
        }
        byte[] out = new byte[outBuffPosn];
        System.arraycopy(outBuff, 0, out, 0, outBuffPosn);
        return out;
    }

    private static int decode4to3(byte[] source, int srcOffset, byte[] destination, int destOffset) {
        if (source[srcOffset + 2] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12;
            destination[destOffset] = (byte)(outBuff >>> 16);
            return 1;
        }
        if (source[srcOffset + 3] == 61) {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6;
            destination[destOffset] = (byte)(outBuff >>> 16);
            destination[destOffset + 1] = (byte)(outBuff >>> 8);
            return 2;
        }
        try {
            int outBuff = (DECODABET[source[srcOffset]] & 0xFF) << 18 | (DECODABET[source[srcOffset + 1]] & 0xFF) << 12 | (DECODABET[source[srcOffset + 2]] & 0xFF) << 6 | DECODABET[source[srcOffset + 3]] & 0xFF;
            destination[destOffset] = (byte)(outBuff >> 16);
            destination[destOffset + 1] = (byte)(outBuff >> 8);
            destination[destOffset + 2] = (byte)outBuff;
            return 3;
        }
        catch (Exception exception) {
            System.out.println(source[srcOffset] + ": " + DECODABET[source[srcOffset]]);
            System.out.println(source[srcOffset + 1] + ": " + DECODABET[source[srcOffset + 1]]);
            System.out.println(source[srcOffset + 2] + ": " + DECODABET[source[srcOffset + 2]]);
            System.out.println(source[srcOffset + 3] + ": " + DECODABET[source[srcOffset + 3]]);
            return -1;
        }
    }

    private static byte[] encode3to4(byte[] source, int srcOffset, int numSigBytes, byte[] destination, int destOffset) {
        int inBuff = (numSigBytes > 0 ? source[srcOffset] << 24 >>> 8 : 0) | (numSigBytes > 1 ? source[srcOffset + 1] << 24 >>> 16 : 0) | (numSigBytes > 2 ? source[srcOffset + 2] << 24 >>> 24 : 0);
        switch (numSigBytes) {
            case 3: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = ALPHABET[inBuff & 0x3F];
                return destination;
            }
            case 2: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = ALPHABET[inBuff >>> 6 & 0x3F];
                destination[destOffset + 3] = 61;
                return destination;
            }
            case 1: {
                destination[destOffset] = ALPHABET[inBuff >>> 18];
                destination[destOffset + 1] = ALPHABET[inBuff >>> 12 & 0x3F];
                destination[destOffset + 2] = 61;
                destination[destOffset + 3] = 61;
                return destination;
            }
        }
        return destination;
    }

    private static byte[] encode3to4(byte[] b4, byte[] threeBytes, int numSigBytes) {
        Base64.encode3to4(threeBytes, 0, numSigBytes, b4, 0);
        return b4;
    }

    public static String encodeBytes(byte[] source) {
        return Base64.encodeBytes(source, 0, source.length, 0);
    }

    public static String encodeBytes(byte[] source, int options) {
        return Base64.encodeBytes(source, 0, source.length, options);
    }

    public static String encodeBytes(byte[] source, int off, int len) {
        return Base64.encodeBytes(source, off, len, 0);
    }

    public static String encodeBytes(byte[] source, int off, int len, int options) {
        int dontBreakLines = options & 8;
        boolean breakLines = dontBreakLines == 0;
        int len43 = len * 4 / 3;
        byte[] outBuff = new byte[len43 + (len % 3 > 0 ? 4 : 0) + (breakLines ? len43 / 76 : 0)];
        int d2 = 0;
        int e2 = 0;
        int len2 = len - 2;
        int lineLength = 0;
        while (d2 < len2) {
            Base64.encode3to4(source, d2 + off, 3, outBuff, e2);
            if (breakLines && (lineLength += 4) == 76) {
                outBuff[e2 + 4] = 10;
                ++e2;
                lineLength = 0;
            }
            d2 += 3;
            e2 += 4;
        }
        if (d2 < len) {
            Base64.encode3to4(source, d2 + off, len - d2, outBuff, e2);
            e2 += 4;
        }
        try {
            return new String(outBuff, 0, e2, PREFERRED_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(outBuff, 0, e2);
        }
    }
}

